#include <string>
#include <typeinfo>

//include <TTCN3.hh>

#include "GeoNetworkingCodec.hh"
#include "loggers.hh"

#include "LibItsGeoNetworking_TypesAndValues.hh"

template <typename T_type> class OPTIONAL;
class TTCN_EncDec;

int GeoNetworkingCodec::encode (const LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu& msg, OCTETSTRING& data)
{
    loggers::loggers::log_msg(">>> GeoNetworkingCodec::encode: ", (const Base_Type&)msg);
    TTCN_Buffer encoding_buffer;
    encode_(msg, LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu_descr_, encoding_buffer);
    data = OCTETSTRING(encoding_buffer.get_len(), encoding_buffer.get_data());
    // Overwrite the payload length
    if (_ec.plLength_position != (unsigned int)-1) {
        loggers::loggers::log("GeoNetworkingCodec::encode: length=%d - plLength_position = %d - plLength = %d", data.lengthof(), _ec.plLength_position, _ec.plLength);
        unsigned char b[] = { (unsigned char)((_ec.plLength & 0x0000FF00) >> 8), (unsigned char)_ec.plLength };
        OCTETSTRING rpl(sizeof(b), b);
        data = replace(data, _ec.plLength_position, rpl.lengthof(), rpl);
    }

    return 0;
}

int GeoNetworkingCodec::decode (const OCTETSTRING& data, LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu& msg)
{
    TTCN_Buffer decoding_buffer(data);
    loggers::loggers::log_to_hexa(">>> GeoNetworkingCodec::decode: decoding_buffer=", decoding_buffer);
    decode_(msg, LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu_descr_, decoding_buffer);
    loggers::loggers::log_msg("<<< GeoNetworkingCodec::decode: ", (const Base_Type&)msg);
    return 0;
}

int GeoNetworkingCodec::decode_ (Base_Type& type, const TTCN_Typedescriptor_t& field_descriptor, TTCN_Buffer& decoding_buffer)
{
    loggers::loggers::log(">>> GeoNetworkingCodec::decode_: processing %s/%s", type.get_descriptor()->name, field_descriptor.name);

    if (dynamic_cast<Record_Type *>(&type) != NULL) {
        Record_Type& r = (Record_Type &)type;
        loggers::loggers::log("GeoNetworkingCodec::decode_: processing Record_Type %s", r.get_descriptor()->name);
        for(int i = 0; i < r.get_count(); i++) {
            loggers::loggers::log("GeoNetworkingCodec::decode_: processing %s/%s/%s", r.fld_name(i), r.fld_descr(i)->name, r.get_at(i)->get_descriptor()->name);
            if (decode_(*((Base_Type *)(r.get_at(i))), *(r.fld_descr(i)), decoding_buffer) == -1) {
                return -1;
            }
        } // End of 'for' statement
    } else {
        loggers::loggers::log("GeoNetworkingCodec::decode_ (else): processing type %s/%s - optional:%d", type.get_descriptor()->name, field_descriptor.name, type.is_optional());
        if (std::string(field_descriptor.name).compare("@LibItsGeoNetworking_TypesAndValues.CommonHeader.nextHeader") == 0) {
            // Decode NextHeader data structure
            type.decode(field_descriptor, decoding_buffer, TTCN_EncDec::CT_RAW);
            // Store NextHeader field value and continue decoding
            _dc.next_header = (unsigned int)dynamic_cast<const Enum_Type &>(type).as_int();
//            loggers::loggers::log("GeoNetworkingCodec::decode_: Storing next_header %d for %s", _dc.next_header, field_descriptor.name);
        } else if (std::string(field_descriptor.name).compare("@LibItsGeoNetworking_TypesAndValues.CommonHeader.headerTST") == 0) {
            // Decode HeaderTST data structure
            type.decode(field_descriptor, decoding_buffer, TTCN_EncDec::CT_RAW);
            // Store HeaderTST field value and continue decoding
//            const LibItsGeoNetworking__TypesAndValues::HeaderTST & h = dynamic_cast<const LibItsGeoNetworking__TypesAndValues::HeaderTST &>(type);
//            switch (h.get_selection()) {
//                case LibItsGeoNetworking__TypesAndValues::HeaderTST::ALT_anyHdr:
//                    _dc.header_type = (unsigned int)dynamic_cast<const Enum_Type &>(*h.anyHdr().get_at(0)).as_int();
//                    _dc.header_sub_type = (unsigned int)static_cast<int>(dynamic_cast<const INTEGER &>(*h.anyHdr().get_at(1)));
//                    break;
//                case LibItsGeoNetworking__TypesAndValues::HeaderTST::ALT_beaconHdr:
//                    _dc.header_type = (unsigned int)dynamic_cast<const Enum_Type &>(*h.beaconHdr().get_at(0)).as_int();
//                    _dc.header_sub_type = (unsigned int)static_cast<int>(dynamic_cast<const INTEGER &>(*h.beaconHdr().get_at(1)));
//                    break;
//                case LibItsGeoNetworking__TypesAndValues::HeaderTST::ALT_geoUnicastHdr:
//                    _dc.header_type = (unsigned int)dynamic_cast<const Enum_Type &>(*h.geoUnicastHdr().get_at(0)).as_int();
//                    _dc.header_sub_type = (unsigned int)static_cast<int>(dynamic_cast<const INTEGER &>(*h.geoUnicastHdr().get_at(1)));
//                    break;
//                case LibItsGeoNetworking__TypesAndValues::HeaderTST::ALT_geoAnycastHdr:
//                    _dc.header_type = (unsigned int)dynamic_cast<const Enum_Type &>(*h.geoAnycastHdr().get_at(0)).as_int();
//                    _dc.header_sub_type = (unsigned int)static_cast<int>(dynamic_cast<const INTEGER &>(*h.geoAnycastHdr().get_at(1)));
//                    break;
//                case LibItsGeoNetworking__TypesAndValues::HeaderTST::ALT_geoBroadcastHdr:
//                    _dc.header_type = (unsigned int)dynamic_cast<const Enum_Type &>(*h.geoBroadcastHdr().get_at(0)).as_int();
//                    _dc.header_sub_type = (unsigned int)static_cast<int>(dynamic_cast<const INTEGER &>(*h.geoBroadcastHdr().get_at(1)));
//                    break;
//                case LibItsGeoNetworking__TypesAndValues::HeaderTST::ALT_tsbHdr:
//                    _dc.header_type = (unsigned int)dynamic_cast<const Enum_Type &>(*h.tsbHdr().get_at(0)).as_int();
//                    _dc.header_sub_type = (unsigned int)static_cast<int>(dynamic_cast<const INTEGER &>(*h.tsbHdr().get_at(1)));
//                    break;
//                case LibItsGeoNetworking__TypesAndValues::HeaderTST::ALT_lsHdr:
//                    _dc.header_type = (unsigned int)dynamic_cast<const Enum_Type &>(*h.lsHdr().get_at(0)).as_int();
//                    _dc.header_sub_type = (unsigned int)static_cast<int>(dynamic_cast<const INTEGER &>(*h.lsHdr().get_at(1)));
//                    break;
//                case LibItsGeoNetworking__TypesAndValues::HeaderTST::ALT_saHdr:
//                    _dc.header_type = (unsigned int)dynamic_cast<const Enum_Type &>(*h.saHdr().get_at(0)).as_int();
//                    _dc.header_sub_type = (unsigned int)static_cast<int>(dynamic_cast<const INTEGER &>(*h.saHdr().get_at(1)));
//                    break;
//                default: TTCN_error("GeoNetworkingCodec::decode_: Invalid selection in union is_bound");
//            } // End of 'switch' statement
        } else if (std::string(field_descriptor.name).compare("@LibItsGeoNetworking_TypesAndValues.CommonHeader.plLength") == 0) {
            // Decode plLength data structure
            type.decode(field_descriptor, decoding_buffer, TTCN_EncDec::CT_RAW);
            // Store playload length and continue decoding
            _dc.plLength = (unsigned int)static_cast<int>(dynamic_cast<const INTEGER &>(type));
//            loggers::loggers::log("GeoNetworkingCodec::decode_: Storing position payload length: %d", _dc.plLength);
        } else if (std::string(field_descriptor.name).compare("@LibItsGeoNetworking_TypesAndValues.GnNonSecuredPacket.extendedHeader") == 0) {
            // Decode ExtendedHeader data structure
            LibItsGeoNetworking__TypesAndValues::ExtendedHeader e;
            e.decode(LibItsGeoNetworking__TypesAndValues::ExtendedHeader_descr_, decoding_buffer, TTCN_EncDec::CT_RAW);
            if (e.is_bound()) {
//            	OPTIONAL<LibItsGeoNetworking__TypesAndValues::ExtendedHeader> o(e);
//                loggers::loggers::log_msg("GeoNetworkingCodec::decode_: o = ", o);
                dynamic_cast<OPTIONAL<LibItsGeoNetworking__TypesAndValues::ExtendedHeader> &>(type) = OPTIONAL<LibItsGeoNetworking__TypesAndValues::ExtendedHeader>(e);
                loggers::loggers::log_msg("GeoNetworkingCodec::decode_: Set OPTIONAL to ", type);
            } else {
                loggers::loggers::log("GeoNetworkingCodec::decode_: Set OPTIONAL to omit");
                dynamic_cast<OPTIONAL<LibItsGeoNetworking__TypesAndValues::ExtendedHeader> &>(type).set_to_omit();
            }
        } else if (std::string(type.get_descriptor()->name).compare("@LibItsGeoNetworking_TypesAndValues.GnNonSecuredPacket.payload") == 0) {
            LibItsGeoNetworking__TypesAndValues::Payload p;
            p.decode(LibItsGeoNetworking__TypesAndValues::Payload_descr_, decoding_buffer, TTCN_EncDec::CT_RAW);
            loggers::loggers::log_msg("GeoNetworkingCodec::decode_: payload= ", p);
            if (p.is_bound()) {
//            	OPTIONAL<LibItsGeoNetworking__TypesAndValues::ExtendedHeader> o(e);
//                loggers::loggers::log_msg("GeoNetworkingCodec::decode_: o = ", o);
                dynamic_cast<OPTIONAL<LibItsGeoNetworking__TypesAndValues::Payload> &>(type) = OPTIONAL<LibItsGeoNetworking__TypesAndValues::Payload>(p);
                loggers::loggers::log_msg("GeoNetworkingCodec::decode_: Set OPTIONAL to ", type);
            } else {
                loggers::loggers::log("GeoNetworkingCodec::decode_: Set OPTIONAL to omit");
                dynamic_cast<OPTIONAL<LibItsGeoNetworking__TypesAndValues::Payload> &>(type).set_to_omit();
            }
        } else if (std::string(type.get_descriptor()->name).compare("@LibItsGeoNetworking_TypesAndValues.decodedPayload") == 0) {
            dynamic_cast<OPTIONAL<LibItsGeoNetworking__TypesAndValues::DecodedPayload> &>(type).set_to_omit();
        } else if (std::string(field_descriptor.name).compare("@LibItsGeoNetworking_TypesAndValues.Payload.rawPayload") == 0) {
            // Decode RawPayload data structure
            type.decode(field_descriptor, decoding_buffer, TTCN_EncDec::CT_RAW);
            // Store it
            const OCTETSTRING& s = dynamic_cast<const OCTETSTRING &>(type);
            const unsigned char * p = static_cast<const unsigned char *>(s);
            if ((unsigned char)s.lengthof() <= _dc.plLength) {
                _dc.payload.assign(p, p + s.lengthof());
            } else {
                _dc.payload.assign(p, p + _dc.plLength);
            }
        } else {
            type.decode(field_descriptor, decoding_buffer, TTCN_EncDec::CT_RAW);
        }
    }

    loggers::loggers::log_msg("<<< GeoNetworkingCodec::decode_: ", type);
    loggers::loggers::log_to_hexa("<<< GeoNetworkingCodec::decode_: decoding_buffer=", decoding_buffer);

    return 0;
}

int GeoNetworkingCodec::encode_ (const Base_Type& type, const TTCN_Typedescriptor_t& field_descriptor, TTCN_Buffer& encoding_buffer)
{
    loggers::loggers::log(">>> GeoNetworkingCodec::encode_: processing %s/%s", type.get_descriptor()->name, field_descriptor.name);
    loggers::loggers::log_msg(">>> GeoNetworkingCodec::encode_: ", type);

    if (dynamic_cast<const Record_Type *>(&type) != NULL) {
        const Record_Type& r = (const Record_Type &)type;
        loggers::loggers::log("GeoNetworkingCodec::encode_: processing Record_Type %s", r.get_descriptor()->name);
        for(int i = 0; i < r.get_count(); i++) {
            loggers::loggers::log("GeoNetworkingCodec::encode_: processing %s/%s/%s - %d (1 ==> use dynamic_cast<const OPTIONAL<...>) - %d", r.fld_name(i), r.fld_descr(i)->name, r.get_at(i)->get_descriptor()->name, r.get_at(i)->is_optional(), r.get_at(i)->is_present());
            if (r.get_at(i)->is_present()) {
                if (encode_(*r.get_at(i), *r.fld_descr(i), encoding_buffer) == -1) {
                    return -1;
                }
            }
        } // End of 'for' statement
    } else if (std::string(type.get_descriptor()->name).compare("@LibItsGeoNetworking_TypesAndValues.ExtendedHeader") == 0) {
        const OPTIONAL<LibItsGeoNetworking__TypesAndValues::ExtendedHeader> &v = dynamic_cast<const OPTIONAL<LibItsGeoNetworking__TypesAndValues::ExtendedHeader> &>(type);
        loggers::loggers::log("GeoNetworkingCodec::encode_: ExtendedHeader present: %d", v.is_present());
        if (v.is_present()) {
            if (encode_extendedHeader(static_cast<const LibItsGeoNetworking__TypesAndValues::ExtendedHeader &>(*v.get_opt_value()), encoding_buffer) == -1) {
                return -1;
            }
        }
    } else if (std::string(type.get_descriptor()->name).compare("@LibItsGeoNetworking_TypesAndValues.Payload") == 0) {
        const OPTIONAL<LibItsGeoNetworking__TypesAndValues::Payload> &v = dynamic_cast<const OPTIONAL<LibItsGeoNetworking__TypesAndValues::Payload> &>(type);
        loggers::loggers::log("GeoNetworkingCodec::encode_: Payload present: %d", v.is_present());
        if (v.is_present()) {
            if (encode_(static_cast<const LibItsGeoNetworking__TypesAndValues::Payload &>(*v.get_opt_value()), LibItsGeoNetworking__TypesAndValues::Payload_descr_, encoding_buffer) == -1) {
                return -1;
            }
        }
    } else if (std::string(type.get_descriptor()->name).compare("@LibItsGeoNetworking_TypesAndValues.DecodedPayload") == 0) {
        const OPTIONAL<LibItsGeoNetworking__TypesAndValues::DecodedPayload> &v = dynamic_cast<const OPTIONAL<LibItsGeoNetworking__TypesAndValues::DecodedPayload> &>(type);
        loggers::loggers::log("GeoNetworkingCodec::encode_: DecodedPayload present: %d", v.is_present());
        if (v.is_present()) {
            if (encode_decodedPayload(static_cast<const LibItsGeoNetworking__TypesAndValues::DecodedPayload &>(*v.get_opt_value()), encoding_buffer) == -1) {
                return -1;
            }
        }
    } else {
        loggers::loggers::log("GeoNetworkingCodec::encode_ (else): processing type %s/%s", type.get_descriptor()->name, field_descriptor.name);
        if (std::string(field_descriptor.name).compare("@LibItsGeoNetworking_TypesAndValues.CommonHeader.nextHeader") == 0) {
            // Store NextHeader field value and continue encoding
            _ec.next_header = (unsigned int)dynamic_cast<const Enum_Type &>(type).as_int();
            loggers::loggers::log("GeoNetworkingCodec::encode_: Storing next_header %d for %s", _ec.next_header, field_descriptor.name);
        } else if (std::string(field_descriptor.name).compare("@LibItsGeoNetworking_TypesAndValues.CommonHeader.headerType") == 0) {
            // Store HeaderType field value and continue encoding
            _ec.header_type = (unsigned int)dynamic_cast<const Enum_Type &>(type).as_int();
            loggers::loggers::log("GeoNetworkingCodec::encode_: Storing header_type %d for %s", _ec.header_type, field_descriptor.name);
        } else  if (std::string(field_descriptor.name).compare("@LibItsGeoNetworking_TypesAndValues.CommonHeader.plLength") == 0) {
            // Store TTCN_Buffer position and continue encoding
            _ec.plLength_position = encoding_buffer.get_len();
            loggers::loggers::log("GeoNetworkingCodec::encode_: Storing position %d for %s", _ec.plLength_position, field_descriptor.name);
        } else if (std::string(field_descriptor.name).compare("@LibItsGeoNetworking_TypesAndValues.Payload.rawPayload") == 0) {
            // Store playload length and continue encoding
            _ec.plLength = dynamic_cast<const OCTETSTRING &>(type).lengthof();
            loggers::loggers::log("GeoNetworkingCodec::encode_: Storing payload length %d for %s", _ec.plLength, field_descriptor.name);
        }
        type.encode(field_descriptor, encoding_buffer, TTCN_EncDec::CT_RAW);
    }

    loggers::loggers::log_to_hexa("<<<GeoNetworkingCodec::encode_: encoding_buffer=", encoding_buffer);
    return 0;
}

int GeoNetworkingCodec::encode_extendedHeader(const LibItsGeoNetworking__TypesAndValues::ExtendedHeader& u, TTCN_Buffer& encoding_buffer) {
    loggers::loggers::log(">>> GeoNetworkingCodec::encode_extendedHeader: processing %s", u.get_descriptor()->name);

    int result = -1;
    switch (u.get_selection()) {
        case LibItsGeoNetworking__TypesAndValues::ExtendedHeader::UNBOUND_VALUE:
            TTCN_error("GeoNetworkingCodec::encode_extendedHeader: Invalid selection in unbound union");
            break;
        case LibItsGeoNetworking__TypesAndValues::ExtendedHeader::ALT_geoUnicastHeader:
            loggers::loggers::log("GeoNetworkingCodec::encode_extendedHeader: processing type %s", u.geoUnicastHeader().get_descriptor()->name);
            result = encode_(u.geoUnicastHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_geoUnicastHeader_descr_, encoding_buffer);
            break;
        case LibItsGeoNetworking__TypesAndValues::ExtendedHeader::ALT_tsbHeader:
            loggers::loggers::log("GeoNetworkingCodec::encode_extendedHeader: processing type %s", u.tsbHeader().get_descriptor()->name);
            result = encode_(u.tsbHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_tsbHeader_descr_, encoding_buffer);
            break;
        case LibItsGeoNetworking__TypesAndValues::ExtendedHeader::ALT_shbHeader:
            loggers::loggers::log("GeoNetworkingCodec::encode_extendedHeader: processing type %s", u.shbHeader().get_descriptor()->name);
            result = encode_(u.shbHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_shbHeader_descr_, encoding_buffer);
            break;
        case LibItsGeoNetworking__TypesAndValues::ExtendedHeader::ALT_geoBroadcastHeader:
            loggers::loggers::log("GeoNetworkingCodec::encode_extendedHeader: processing type %s", u.geoBroadcastHeader().get_descriptor()->name);
            result = encode_(u.geoBroadcastHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_geoBroadcastHeader_descr_, encoding_buffer);
            break;
        case LibItsGeoNetworking__TypesAndValues::ExtendedHeader::ALT_geoAnycastHeader:
            loggers::loggers::log("GeoNetworkingCodec::encode_extendedHeader: processing type %s", u.geoAnycastHeader().get_descriptor()->name);
            result = encode_(u.geoAnycastHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_geoAnycastHeader_descr_, encoding_buffer);
            break;
        case LibItsGeoNetworking__TypesAndValues::ExtendedHeader::ALT_beaconHeader:
            loggers::loggers::log("GeoNetworkingCodec::encode_extendedHeader: processing type %s", u.beaconHeader().get_descriptor()->name);
            result = encode_(u.beaconHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_beaconHeader_descr_, encoding_buffer);
            break;
        case LibItsGeoNetworking__TypesAndValues::ExtendedHeader::ALT_anyHeader:
            loggers::loggers::log("GeoNetworkingCodec::encode_extendedHeader: processing type %s", u.anyHeader().get_descriptor()->name);
            result = encode_(u.anyHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_anyHeader_descr_, encoding_buffer);
            break;
        case LibItsGeoNetworking__TypesAndValues::ExtendedHeader::ALT_lsRequestHeader:
            loggers::loggers::log("GeoNetworkingCodec::encode_extendedHeader: processing type %s", u.lsRequestHeader().get_descriptor()->name);
            result = encode_(u.lsRequestHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_lsRequestHeader_descr_, encoding_buffer);
            break;
        case LibItsGeoNetworking__TypesAndValues::ExtendedHeader::ALT_lsReplyHeader:
            loggers::loggers::log("GeoNetworkingCodec::encode_extendedHeader: processing type %s", u.lsReplyHeader().get_descriptor()->name);
            result = encode_(u.lsReplyHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_lsReplyHeader_descr_, encoding_buffer);
            break;
        default: TTCN_error("GeoNetworkingCodec::encode_extendedHeader: Invalid selection in union is_bound");
    } // End of 'switch' statement

    return result;
}

int GeoNetworkingCodec::decode_extendedHeader(LibItsGeoNetworking__TypesAndValues::ExtendedHeader& u, TTCN_Buffer& decoding_buffer) {
    loggers::loggers::log(">>> GeoNetworkingCodec::decode_extendedHeader: processing %s", u.get_descriptor()->name);

    int result = -1;
//    size_t bitpos;
//    _dc.header_type = (*decoding_buffer.get_read_data(&bitpos) & (1 << LibItsGeoNetworking__TypesAndValues::HeaderType_raw_::HeaderType_raw_.fieldlength)) >> LibItsGeoNetworking__TypesAndValues::HeaderType_raw_::HeaderType_raw_.fieldlength;
//    switch (_dc.header_type) {
//
////     = 0,  = 1,  = 2,  = 3,  = 4,  = 5, e__locationService = 6, e__serviceAnnouncement = 7, e__reserved = 8, UNKNOWN_VALUE = 9, UNBOUND_VALUE = 10
//
//        case LibItsGeoNetworking__TypesAndValues::HeaderType::e__geoUnicast:
//            loggers::loggers::log("GeoNetworkingCodec::decode_extendedHeader: processing type %s", u.geoUnicastHeader().get_descriptor()->name);
//            result = decode_(u.geoUnicastHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_geoUnicastHeader_descr_, decoding_buffer);
//            break;
//        case LibItsGeoNetworking__TypesAndValues::HeaderType::e__topologicallyScopedBroadcast:
//            _dc.header_sub_type = (*decoding_buffer.get_read_data(&bitpos) & (1 << LibItsGeoNetworking__TypesAndValues::HeaderSubTypeTSB_raw_.fieldlength)) >> LibItsGeoNetworking__TypesAndValues::HeaderSubTypeTSB_raw_.fieldlength;
//            if (header_sub_type == 0) {
//                loggers::loggers::log("GeoNetworkingCodec::decode_extendedHeader: processing type %s", u.shbHeader().get_descriptor()->name);
//                result = decode_(u.shbHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_shbHeader_descr_, decoding_buffer);
//            } else {
//                loggers::loggers::log("GeoNetworkingCodec::decode_extendedHeader: processing type %s", u.tsbHeader().get_descriptor()->name);
//                result = decode_(u.tsbHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_tsbHeader_descr_, decoding_buffer);
//            }
//            break;
//        case LibItsGeoNetworking__TypesAndValues::HeaderType::e__geoBroadcast:
//            loggers::loggers::log("GeoNetworkingCodec::decode_extendedHeader: processing type %s", u.geoBroadcastHeader().get_descriptor()->name);
//            result = decode_(u.geoBroadcastHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_geoBroadcastHeader_descr_, decoding_buffer);
//            break;
//        case LibItsGeoNetworking__TypesAndValues::HeaderType::e__geoAnycast:
//            loggers::loggers::log("GeoNetworkingCodec::decode_extendedHeader: processing type %s", u.geoAnycastHeader().get_descriptor()->name);
//            result = decode_(u.geoAnycastHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_geoAnycastHeader_descr_, decoding_buffer);
//            break;
//        case LibItsGeoNetworking__TypesAndValues::HeaderType::e__beacon:
//            loggers::loggers::log("GeoNetworkingCodec::decode_extendedHeader: processing type %s", u.beaconHeader().get_descriptor()->name);
//            result = decode_(u.beaconHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_beaconHeader_descr_, decoding_buffer);
//            break;
//        case LibItsGeoNetworking__TypesAndValues::HeaderType::e__any:
//            loggers::loggers::log("GeoNetworkingCodec::decode_extendedHeader: processing type %s", u.anyHeader().get_descriptor()->name);
//            result = decode_(u.anyHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_anyHeader_descr_, decoding_buffer);
//            break;
//        case LibItsGeoNetworking__TypesAndValues::HeaderType::e__locationService:
//            _dc.header_sub_type = (*decoding_buffer.get_read_data(&bitpos) & (1 << LibItsGeoNetworking__TypesAndValues::HeaderSubTypeLs_raw_.fieldlength)) >> LibItsGeoNetworking__TypesAndValues::HeaderSubTypeLs_raw_.fieldlength;
//            if (header_sub_type == 0) {
//                loggers::loggers::log("GeoNetworkingCodec::decode_extendedHeader: processing type %s", u.lsRequestHeader().get_descriptor()->name);
//                result = decode_(u.lsRequestHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_lsRequestHeader_descr_, decoding_buffer);
//            } else {
//                loggers::loggers::log("GeoNetworkingCodec::decode_extendedHeader: processing type %s", u.lsReplyHeader().get_descriptor()->name);
//                result = decode_(u.lsReplyHeader(), LibItsGeoNetworking__TypesAndValues::ExtendedHeader_lsReplyHeader_descr_, decoding_buffer);
//            }
//            break;
//        default: TTCN_error("GeoNetworkingCodec::decode_extendedHeader: Invalid selection in union");
//    } // End of 'switch' statement

    return result;
}

int GeoNetworkingCodec::encode_decodedPayload(const LibItsGeoNetworking__TypesAndValues::DecodedPayload& u, TTCN_Buffer& encoding_buffer) {
    loggers::loggers::log(">>> GeoNetworkingCodec::encode_decodedPayload: processing %s", u.get_descriptor()->name);

    int result = -1;
    switch (u.get_selection()) {
        case LibItsGeoNetworking__TypesAndValues::DecodedPayload::UNBOUND_VALUE:
            TTCN_error("GeoNetworkingCodec::encode_decodedPayload: Invalid selection in unbound union");
            break;
        case LibItsGeoNetworking__TypesAndValues::DecodedPayload::ALT_ipv6Packet:
            loggers::loggers::log("GeoNetworkingCodec::encode_decodedPayload: processing type %s", u.ipv6Packet().get_descriptor()->name);
            //result = encode_(u.geoUnicastHeader(), LibItsGeoNetworking__TypesAndValues::DecodedPayload_ipv6Packet_descr_, encoding_buffer);
            break;
        case LibItsGeoNetworking__TypesAndValues::DecodedPayload::ALT_btpPacket:
            loggers::loggers::log("GeoNetworkingCodec::encode_decodedPayload: processing type %s", u.btpPacket().get_descriptor()->name);
            //result = encode_(u.geoUnicastHeader(), LibItsGeoNetworking__TypesAndValues::DecodedPayload_btpPacket_descr_, encoding_buffer);
            break;
        default: TTCN_error("GeoNetworkingCodec::encode_decodedPayload: Invalid selection in union is_bound");
    } // End of 'switch' statement

    return result;
}

