#include "EthernetLayer.hh"
#include "loggers.hh"

EthernetLayer::EthernetLayer(const std::string & type, const std::string & param) : EthernetLayer() {
    loggers::loggers::log(">>> EthernetLayer::EthernetLayer: %s, %s", type.c_str(), param.c_str());
    // Setup parameters
}

void EthernetLayer::sendData(const OCTETSTRING& data, const Params& params) {
}

void EthernetLayer::receiveData(const OCTETSTRING& data, const Params& info) {
}

class EthernetFactory: public LayerFactory {
    static EthernetFactory _f;
public:
    EthernetFactory();
    virtual Layer * createLayer(const std::string & type,
            const std::string & param);
};

EthernetFactory::EthernetFactory() {
    // register factory
    loggers::loggers::log(">>> EthernetFactory::EthernetFactory");
    LayerStackBuilder::RegisterLayerFactory("ETH", this);
}

Layer * EthernetFactory::createLayer(const std::string & type, const std::string & param) {
    return new EthernetLayer(type, param);
}

EthernetFactory EthernetFactory::_f;
