#ifndef CAMCODEC_H
#define CAMCODEC_H
#include "Codec.hh"

#include "LibItsCam_TestSystem.hh"

class CAMPDUCodec : public PERCodec <CAM__PDU__Descriptions::CAM>
{
public:
	CAMPDUCodec(){}
	virtual int encode (const CAM__PDU__Descriptions::CAM& cam, BITSTRING& data);
	virtual int decode (const BITSTRING& data, CAM__PDU__Descriptions::CAM&);
};

class CAMCodec : public Codec<
	LibItsCam__TestSystem::CamReq,
	LibItsCam__TestSystem::CamInd>
{
	CAMPDUCodec asnCodec;
public:
	virtual int encode (const LibItsCam__TestSystem::CamReq& cam, OCTETSTRING& data);
	virtual int decode (const OCTETSTRING& data, LibItsCam__TestSystem::CamInd&);
};

#endif
