#ifndef BTP_LAYER_H
#define BTP_LAYER_H
#include "Layer.hh"
#include "BTPCodec.hh"

namespace LibItsBtp__TypesAndValues {
	class BtpPacket;
}

namespace LibItsBtp__TestSystem {
	class BtpPort;
}

class BTPLayer : public TLayer<LibItsBtp__TestSystem::BtpPort> {
    BTPCodec _codec;
  public:
    inline BTPLayer():TLayer<LibItsBtp__TestSystem::BtpPort>(){}
    virtual ~BTPLayer(){}

    void sendMsg(const LibItsBtp__TypesAndValues::BtpPacket&, const Params& param);
    
    virtual void sendData(const OCTETSTRING& data, const Params& params);
    virtual void receiveData(const OCTETSTRING& data, const Params& info);
};

#endif
