#include "BTPLayer.hh"
#include "BTPTypes.hh"

void BTPLayer::sendMsg(const LibItsBtp__TypesAndValues::BtpPacket& p, const Params& params){
  OCTETSTRING data;
  _codec.encode(p, data);
  sendData(data, params);
}

void BTPLayer::sendData(const OCTETSTRING& data, const Params& params){
  sendToAllLayers(data, params);
}

void BTPLayer::receiveData(const OCTETSTRING& data, const Params& info)
{
  LibItsBtp__TypesAndValues::BtpPacket p;
  _codec.decode(data, p);

  toAllUpperPorts(p, info);

  if(p.payload().is_present()) {
    toAllUpperLayers(p.payload()().rawPayload(), info);
  }
}

class BTPFactory : public LayerFactory {
  static BTPFactory _f;
public:
  BTPFactory();
  virtual Layer * createLayer(const std::string &  type, const std::string &  param);
};

BTPFactory::BTPFactory(){
  // register factory
	LayerStackBuilder::RegisterLayerFactory("BTP", this);
}

Layer * BTPFactory::createLayer(const std::string & type, const std::string & param){
  return new BTPLayer();
}

BTPFactory BTPFactory::_f;
