#include "Layer.hh"
#include <stdexcept>
#include <regex>

#include "loggers.hh"

LayerStackBuilder * LayerStackBuilder::_instance = NULL;

// static functions
LayerStackBuilder * LayerStackBuilder::GetInstance()
{
  return _instance ? _instance : _instance = new LayerStackBuilder();
}

void LayerStackBuilder::RegisterLayerFactory(const std::string & type, LayerFactory * f)
{
    LayerStackBuilder::GetInstance()->registerLayerFactory(type, f);
}

// member functions
LayerStackBuilder::LayerStackBuilder()
{
}

void LayerStackBuilder::registerLayerFactory(const std::string & type, LayerFactory * f)
{
    _fs[type] = f;
}

Layer* LayerStackBuilder::createLayerStack(const char* s)
{
    loggers::loggers::log(">>> LayerStackBuilder::createLayerStack: %s", s);

    Layer * up = NULL;
    // Parse str
    try {
        std::regex rgx ("(\\w+)(\\((.*?)\\))?(\\/|$)");
        std::string str = s;
        std::sregex_iterator begin(str.cbegin(), str.cend(), rgx);
        std::sregex_iterator end = std::sregex_iterator();
        for (std::sregex_iterator it = begin; it != end; ++it) {
            std::smatch m = *it;
            loggers::loggers::log("LayerStackBuilder::createLayerStack: %d - %s - %s - %s - %s", m.size(), m[0].str().c_str(), m[1].str().c_str(), m[2].str().c_str(), m[3].str().c_str());
            std::string mname = m[1].str();
            if (mname.find_first_of('/') != std::string::npos) {
                mname.replace(mname.find_first_of('/'), 1, "");
            }
            LayerFactoryMap::iterator i =_fs.find(mname);
            if (i == _fs.end()) {
                loggers::loggers::error("LayerStackBuilder::createLayerStack: %s: Unknown layer type", mname.c_str());
                throw (std::logic_error(mname + ": Unknown layer type"));
            }
            // TODO: parse parameters
            loggers::loggers::log("LayerStackBuilder::createLayerStack: Create layer %s", i->first.c_str());
            Layer * l = i->second->createLayer(mname, m[3]);
            if(NULL == l){
                loggers::loggers::error("LayerStackBuilder::createLayerStack: %s: Layer creation error", mname.c_str());
                throw (std::logic_error(mname + ": Layer creation error"));
            }

            l->addUpperLayer(up);
            up = l;
        }
    }
    catch(const std::logic_error& e){
        if(up){
            up->deleteLayer();
            up = NULL;
        }
    }
    return up;
}
