#ifndef LAYER_HH
#define LAYER_HH
#include <string>
#include <map>
#include <vector>

typedef std::map<std::string, std::string> Params;
class OCTETSTRING;

class Layer {
  std::vector<Layer*> upperLayers;
  std::vector<Layer*> lowerLayers;
  public:
    Layer(){}
    virtual ~Layer() {};
    void deleteLayer() {};
  public:
    void addUpperLayer(Layer*) {};
    void removeUpperLayer(Layer*) {};

    virtual void sendData(const OCTETSTRING& data, const Params& params) {};
    virtual void receiveData(const OCTETSTRING& data, const Params& info) {};

  protected:
    void toAllLayers(std::vector<Layer*>&layers, const OCTETSTRING& data, const Params& info) {};
    inline void toAllUpperLayers(const OCTETSTRING& data, const Params& info) { toAllLayers(upperLayers, data, info); }
    inline void toAllLowerLayers(const OCTETSTRING& data, const Params& info) { toAllLayers(upperLayers, data, info); }
    inline void receiveToAllLayers(const OCTETSTRING& data, const Params& info) { toAllLayers(upperLayers, data, info); }
    inline void sendToAllLayers(const OCTETSTRING& data, const Params& info)  { toAllLayers(lowerLayers, data, info); }
};


template <typename TPort> class TLayer : public Layer {
  typedef std::vector<TPort*> TPortList;
  typedef typename std::vector<TPort*>::iterator TPortListIterator;

  TPortList upperPorts;
  
  public:
    TLayer(){}
    void addUpperPort(TPort*);
    void removeUpperPort(TPort*);

  protected:
    template <typename TMessage> void toAllUpperPorts(const TMessage& m, const Params& param) {
      for(TPortListIterator it=upperPorts.begin(); it<upperPorts.end(); ++it){
        (*it)->receiveMsg(m, param);
      }
    }
};


class LayerFactory {
  public:
   LayerFactory(){}
   virtual Layer * createLayer(const std::string & type, const std::string &  param) = 0;
};

class LayerStackBuilder {
   typedef std::map<std::string, LayerFactory*> LayerFactoryMap;

   static LayerStackBuilder * _instance;
   std::map<std::string, LayerFactory*> _fs;
  private:
   LayerStackBuilder(); // can not be created manually
  public:
   static LayerStackBuilder * GetInstance();
   static void RegisterLayerFactory(const std::string & type, LayerFactory * f);

  public:
   void registerLayerFactory(const std::string & type, LayerFactory * f);
   Layer* createLayerStack(const char*);
};

#endif
