#ifndef CODEC_H
#define CODEC_H
class OCTETSTRING;
class BITSTRING;
template<typename TPDUEnc, typename TPDUDec> class Codec
{
public:
	virtual int encode(const TPDUEnc& msg, OCTETSTRING& data) = 0;
	virtual int decode(const OCTETSTRING& data, TPDUDec& msg) = 0;
};

template<typename TPDU> class PERCodec
{
public:
	virtual int encode(const TPDU& msg, BITSTRING& bits);
	virtual int decode(const BITSTRING& bits, TPDU& msg);
};

#endif
