#include "LibItsSecurity_Functions.hh"

namespace LibItsSecurity__Functions 
{
//        group signing
/*          * @desc    Produces a 256-bit (32-byte) hash value
            * @param   p_toBeHashedData Data to be used to calculate the hash value
            * @return  The hash value
            fx_hashWithSha256(in octetstring p_toBeHashedData) return Oct32;
*/
OCTETSTRING fx__hashWithSha256(
  const OCTETSTRING& p__toBeHashedData
) {
//RGY when implementing, look at TCC_Useful_functions/TCCSecurity_Functions
	OCTETSTRING ret_val = int2oct(0,1);
	return ret_val;
}

/*          * @desc    Produces a Elliptic Curve Digital Signature Algorithm (ECDSA) signaturee
            * @param   p_toBeSignedSecuredMessage    The data to be signed
            * @param   p_privateKey        The private key
            * @return  The signature value
            fx_signWithEcdsaNistp256WithSha256(in octetstring p_toBeSignedSecuredMessage, in octetstring<UInt64> p_privateKey) return octetstring;
*/
OCTETSTRING fx__signWithEcdsaNistp256WithSha256(
  const OCTETSTRING& p__toBeSignedSecuredMessage,
  const OCTETSTRING& p__privateKey
) {
	OCTETSTRING ret_val = int2oct(0,1);
	return ret_val;
}

/*          * @desc    Verify the signature of the specified data
            * @param   p_toBeVerifiedData          The data to be verified
            * @param   p_signature                 The signature
            * @param   p_ecdsaNistp256PublicKeyX   The public key (x coordinate)
            * @param   p_ecdsaNistp256PublicKeyY   The public key (y coordinate)
            * @return  true on success, false otherwise
            fx_verifyWithEcdsaNistp256WithSha256(in octetstring p_toBeVerifiedData, in octetstring p_signature, in octetstring p_ecdsaNistp256PublicKeyX, in octetstring p_ecdsaNistp256PublicKeyY) return boolean;
*/
BOOLEAN fx__verifyWithEcdsaNistp256WithSha256(
  const OCTETSTRING& p__toBeVerifiedData,
  const OCTETSTRING& p__signature,
  const OCTETSTRING& p__ecdsaNistp256PublicKeyX,
  const OCTETSTRING& p__ecdsaNistp256PublicKeyY
) {
   return TRUE;
}

/*          * @desc    Produce a new public/private key pair based on Elliptic Curve Digital Signature Algorithm (ECDSA) algorithm.
            *          This function should not be used by the ATS
            * @param   p_privateKey    The new private key value
            * @param   p_publicKeyX    The new public key value (x coordinate)
            * @param   p_publicKeyX    The new public key value (y coordinate)
            * @return  true on success, false otherwise
            fx_generateKeyPair(out octetstring<UInt64> p_privateKey, out octetstring p_publicKeyX, out octetstring p_publicKeyY) return boolean;
*/
BOOLEAN fx__generateKeyPair(
  OCTETSTRING& p__privateKey,
  OCTETSTRING& p__publicKeyX,
  OCTETSTRING& p__publicKeyY
) {
   return TRUE;
}

//        group encryption

//        group certificatesLoader

/*          * @desc    Load in memory cache the certificates available in the specified directory
            * @param   p_rootDirectory Root directory to access to the certificates identified by the certificate ID
            * @param   p_configId      A configuration identifier
            * @remark  This method SHALL be call before any usage of certificates
            * @return  true on success, false otherwise
            fx_loadCertificates(in charstring p_rootDirectory, in charstring p_configId) return boolean;
*/
BOOLEAN fx__loadCertificates(
  const CHARSTRING& p__rootDirectory,
  const CHARSTRING& p__configId
) {
   return TRUE;
}

/*          * @desc    Unload from memory cache the certificates
            * @return  true on success, false otherwise
            fx_unloadCertificates() return boolean;
*/
BOOLEAN fx__unloadCertificates(
) {
   return TRUE;
}

/*          * @desc    Read the specified certificate
            * @param   p_certificateId the certificate identifier
            * @param   p_certificate   the expected certificate
            * @return  true on success, false otherwise
            fx_readCertificate(in charstring p_certificateId, out octetstring p_certificate) return boolean;
*/
BOOLEAN fx__readCertificate(
  const CHARSTRING& p__certificateId,
  OCTETSTRING& p__certificate
) {
   return TRUE;
}


/*          * @desc    Read the specified certificate digest
            * @param   p_certificateId the certificate identifier
            * @param   p_digest   the expected certificate
            * @return  true on success, false otherwise
            fx_readCertificateDigest(in charstring p_certificateId, out HashedId8 p_digest) return boolean;
*/
BOOLEAN fx__readCertificateDigest(
  const CHARSTRING& p__certificateId,
  OCTETSTRING& p__digest
) {
   return TRUE;
}

/*          * @desc    Read the private keys for the specified certificate
            * @param   p_keysId            the keys identifier
            * @param   p_signingPrivateKey the signing private key
            * @return  true on success, false otherwise
            fx_readSigningKey(in charstring p_keysId, out Oct32 p_signingPrivateKey) return boolean;
*/
BOOLEAN fx__readSigningKey(
  const CHARSTRING& p__keysId,
  OCTETSTRING& p__signingPrivateKey
) {
   return TRUE;
}

/*          * @desc    Read the private keys for the specified certificate
            * @param   p_keysId            the keys identifier
            * @param   p_encryptPrivateKey the encrypt private key
            * @return  true on success, false otherwise
            fx_readEncryptingKey(in charstring p_keysId, out Oct32 p_encryptingPrivateKey) return boolean;
*/
BOOLEAN fx__readEncryptingKey(
  const CHARSTRING& p__keysId,
  OCTETSTRING& p__encryptingPrivateKey
) {
   return TRUE;
}

//        group geodesic 

/*          * @desc    Check that given polygon doesn't have neither self-intersections nor holes.
            * @param   p_region   Polygonal Region
            * @return  true on success, false otherwise
            * @verdict Unchanged
            fx_isValidPolygonalRegion(in PolygonalRegion p_region) return boolean;
*/
BOOLEAN fx__isValidPolygonalRegion(
  const LibItsSecurity__TypesAndValues::PolygonalRegion& p__region
) {
  return TRUE;
}

/*          * @desc Check if a polygonal region is inside another one
            * @param p_parent  The main polygonal region
            * @param p_region  The polygonal region to be included
            * @return true on success, false otherwise
            * @verdict Unchanged
            fx_isPolygonalRegionInside(in PolygonalRegion p_parent, in PolygonalRegion p_region) return boolean;
*/
BOOLEAN fx__isPolygonalRegionInside(
  const LibItsSecurity__TypesAndValues::PolygonalRegion& p__parent,
  const LibItsSecurity__TypesAndValues::PolygonalRegion& p__region
) {
   return TRUE;
}

/*          * @desc Check that the location is inside a circular region
            * @param p_region      The circular region to consider
            * @param p_location    The device location
            * @return true on success, false otherwise
            * @verdict Unchanged
            fx_isLocationInsideCircularRegion(in CircularRegion p_region, in ThreeDLocation p_location) return boolean;
*/
BOOLEAN fx__isLocationInsideCircularRegion(
  const LibItsSecurity__TypesAndValues::CircularRegion& p__region,
  const LibItsSecurity__TypesAndValues::ThreeDLocation& p__location
) {
   return TRUE;
}

/*          * @desc Check that the location is inside a rectangular region
            * @param p_region      The rectangular region to consider
            * @param p_location    The device location
            * @return true on success, false otherwise
            * @verdict Unchanged
            fx_isLocationInsideRectangularRegion(in RectangularRegions p_region, in ThreeDLocation p_location) return boolean;
*/
BOOLEAN fx__isLocationInsideRectangularRegion(
  const LibItsSecurity__TypesAndValues::RectangularRegions& p__region,
  const LibItsSecurity__TypesAndValues::ThreeDLocation& p__location
) {
   return TRUE;
}

/*          * @desc Check that the location is inside a polygonal region
            * @param p_region      The polygonal region to consider
            * @param p_location    The device location
            * @return true on success, false otherwise
            * @verdict Unchanged
            fx_isLocationInsidePolygonalRegion(in PolygonalRegion p_region, in ThreeDLocation p_location) return boolean;
*/
BOOLEAN fx__isLocationInsidePolygonalRegion(
  const LibItsSecurity__TypesAndValues::PolygonalRegion& p__region,
  const LibItsSecurity__TypesAndValues::ThreeDLocation& p__location
) {
   return TRUE;
}


/*          * @desc Check if the location is inside an identified region
            * @param p_region      The identified region to consider
            * @param p_location    The device location
            * @return true on success, false otherwise
            * @verdict Unchanged
            fx_isLocationInsideIdentifiedRegion(in IdentifiedRegion p_region, in ThreeDLocation p_location) return boolean;
*/
BOOLEAN fx__isLocationInsideIdentifiedRegion(
  const LibItsSecurity__TypesAndValues::IdentifiedRegion& p__region,
  const LibItsSecurity__TypesAndValues::ThreeDLocation& p__location
) {
   return TRUE;
}

/*          * @desc Check if the location is inside an undefined region
            * @param p_region      The identified region to consider
            * @param p_location    The device location
            * @return true on success, false otherwise
            * @verdict Unchanged
            fx_isLocationInsideOtherRegion(in octetstring p_region, in ThreeDLocation p_location) return boolean; 
*/
BOOLEAN fx__isLocationInsideOtherRegion(
  const OCTETSTRING& p_region,
  const LibItsSecurity__TypesAndValues::ThreeDLocation& p_location
) {
   return TRUE;
} 

/*           * @desc    Check that p_circular_region_1 circular region is included into p_circular_region_2 circular region
             * @param   p_circular_region_1    Circular region 1
             * @param   p_circular_region_2    Circular region 2
             * @return  true on success, false otherwise
            fx_areCirclesInside(in CircularRegion p_circular_region_1, in CircularRegion p_circular_region_2) return boolean;
*/
BOOLEAN fx__areCirclesInside(
  const LibItsSecurity__TypesAndValues::CircularRegion& p_circular_region_1,
  const LibItsSecurity__TypesAndValues::CircularRegion& p_circular_region_2
) {
   return TRUE;
}

/*           * @desc    Check that p_rectanglar_region_1 rectangular region is included into p_rectanglar_region_2 rectangular region
             * @param   p_rectanglar_region_1    Rectangular region 1
             * @param   p_rectanglar_region_2    Rectangular region 2
             * @return  true on success, false otherwise
            fx_areRectanglesInside(in RectangularRegions p_rectanglar_region_1, in RectangularRegions p_rectanglar_region_2) return boolean;
*/
BOOLEAN fx__areRectanglesInside(
  const LibItsSecurity__TypesAndValues::RectangularRegions& p_rectanglar_region_1,
  const LibItsSecurity__TypesAndValues::RectangularRegions& p_rectanglar_region_2
) {
   return TRUE;
}

/*           * @desc    Check that p_polygonal_region_1 polygonal region is included into p_polygonal_region_2 polygonal region
             * @param   p_polygonal_region_1    Polygonal region 1
             * @param   p_polygonal_region_2    Polygonal region 2
             * @return  true on success, false otherwise
            fx_arePolygonsInside(in PolygonalRegion p_polygonal_region_1, in PolygonalRegion p_polygonal_region_2) return boolean;
*/
BOOLEAN fx__arePolygonsInside(
  const LibItsSecurity__TypesAndValues::PolygonalRegion& p_polygonal_region_1,
  const LibItsSecurity__TypesAndValues::PolygonalRegion& p_polygonal_region_2
) {
   return TRUE;
}

/*          * @desc Convert a spacial coordinate from DMS to Dms
            * @param p_degrees The degrees (D)
            * @param p_minutes The minutes (M)
            * @param p_seconds The seconds (S)
            * @param p_latlon  The latitude/longitude: (N|S|E|W)
            * @return The decimal coordinate on success, 0.0, otherwise
            * @verdict Unchanged
            fx_dms2dd(in Int p_degrees, in Int p_minutes, in float p_seconds, in Oct1 p_latlon) return float;
*/
FLOAT fx__dms2dd(
  const INTEGER& p__degrees,
  const INTEGER& p__minutes,
  const FLOAT& p__seconds,
  const OCTETSTRING& p__latlon
) {
  return 0.0;
}

} // end of namespace
