#include "LibItsGeoNetworking_EncdecDeclarations.hh"

#include "GeoNetworkingCodec.hh"
#include "loggers.hh"

namespace LibItsGeoNetworking__EncdecDeclarations {
/****************************************************
 * @desc    External function to encode a GeoNetworkingReq type
 * @param   value to encode
 * @return  encoded value
 ****************************************************/
BITSTRING fx__enc__GeoNetworkingReq(LibItsGeoNetworking__TestSystem::GeoNetworkingReq const& p_geoNetworkingReq)
{
    loggers::loggers::log("fx__enc__GeoNetworkingReq");
    GeoNetworkingCodec codec;
    const LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu & pdu = p_geoNetworkingReq.msgOut();
    OCTETSTRING os;
    codec.encode(pdu, os);
    const unsigned char mac_address[] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
    os += OCTETSTRING(sizeof(mac_address), static_cast<const unsigned char *>(mac_address));
    return oct2bit(os);
}

/****************************************************
 * @desc    External function to decode a GeoNetworkingReq type
 * @param   value to encode
 * @return  encoded value
 ****************************************************/

INTEGER fx__dec__GeoNetworkingReq(BITSTRING& b, LibItsGeoNetworking__TestSystem::GeoNetworkingReq& p)
{
    loggers::loggers::log("fx__dec__GeoNetworkingReq");
    GeoNetworkingCodec codec;
    LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu pdu;
    OCTETSTRING is = bit2oct(b);

    if (codec.decode(OCTETSTRING(is.lengthof() - 6, static_cast<const unsigned char *>(is)), pdu) == -1) {
    	return -1;
    }
    const unsigned char mac_address[] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
    p = LibItsGeoNetworking__TestSystem::GeoNetworkingReq(
    		pdu,
			OCTETSTRING(sizeof(mac_address), static_cast<const unsigned char *>(mac_address)),
            0);
    return 0;
}

/****************************************************
 * @desc    External function to encode a GeoNetworkingInd type
 * @param   value to encode
 * @return  encoded value
 ****************************************************/
BITSTRING fx__enc__GeoNetworkingInd(LibItsGeoNetworking__TestSystem::GeoNetworkingInd const& p)
{
    loggers::loggers::log("fx__enc__GeoNetworkingInd");
    return int2bit(0,8);
}

/****************************************************
 * @desc    External function to decode a GeoNetworkingInd type
 * @param   value to encode
 * @return  encoded value
 ****************************************************/

INTEGER fx__dec__GeoNetworkingInd(BITSTRING& b, LibItsGeoNetworking__TestSystem::GeoNetworkingInd& p)
{
    loggers::loggers::log("fx__dec__GeoNetworkingInd");
  return -1;
}

/****************************************************
 * @desc    External function to encode a GeoNetworkingPdu type
 * @param   value to encode
 * @return  encoded value
 ****************************************************/
BITSTRING fx__enc__GeoNetworkingPdu(LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu const& p)
{
    loggers::loggers::log("fx__enc__GeoNetworkingPdu");
    return int2bit(0,8);
}

/****************************************************
 * @desc    External function to decode a GeoNetworkingPdu type
 * @param   value to encode
 * @return  encoded value
 ****************************************************/

INTEGER fx__dec__GeoNetworkingPdu(BITSTRING& b, LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu& p)
{
    loggers::loggers::log("fx__dec__GeoNetworkingPdu");
  return -1;
}

/****************************************************
 * @desc    External function to encode a Payload type
 * @param   value to encode
 * @return  encoded value
 ****************************************************/
BITSTRING fx__enc__Payload(const LibItsGeoNetworking__TypesAndValues::Payload& p)
{
    loggers::loggers::log("fx__enc__Payload");
  return int2bit(0,8);
}

/****************************************************
 * @desc    External function to decode a Payload type
 * @param   value to encode
 * @return  encoded value
 ****************************************************/

INTEGER fx__dec__Payload(BITSTRING& b, LibItsGeoNetworking__TypesAndValues::Payload& p)
{
  return -1;
}

/****************************************************
 * @desc    External function to encode a GnNonSecuredPacket type
 * @param   value to encode
 * @return  encoded value
 ****************************************************/
BITSTRING fx__enc__GnNonSecuredPacket(const LibItsGeoNetworking__TypesAndValues::GnNonSecuredPacket& p)
{
  return int2bit(0,8);
}

/****************************************************
 * @desc    External function to decode a GnNonSecuredPacket type
 * @param   value to encode
 * @return  encoded value
 ****************************************************/

INTEGER fx__dec__GnNonSecuredPacket(BITSTRING& b, LibItsGeoNetworking__TypesAndValues::GnNonSecuredPacket& p)
{
  return -1;
}

} //end namespace
