#include "LibItsDenm_EncdecDeclarations.hh"

namespace LibItsDenm__EncdecDeclarations {
/****************************************************
 * @desc    External function to encode a DenmReq type
 * @param   value to encode
 * @return  encoded value
 ****************************************************/
BITSTRING fx__enc__DenmReq(const LibItsDenm__TestSystem::DenmReq& p)
{
  //set error behavior
  TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL,TTCN_EncDec::EB_WARNING);

  TTCN_Buffer TTCN_buf;
  TTCN_buf.clear();

//encode message in BER (CER variant, but can be any)
  p.msgOut().encode(DENM__PDU__Descriptions::DENM_descr_,TTCN_buf,TTCN_EncDec::CT_BER,BER_ENCODE_CER);


  OCTETSTRING encodedData(TTCN_buf.get_len(), TTCN_buf.get_data());

//insert BER2PER recoding here!

  return oct2bit(encodedData);
}

/****************************************************
 * @desc    External function to decode a DenmReq type
 * @param   value to encode
 * @return  encoded value
 ****************************************************/
//function not needed yet, decvalue() is not used in TTCN-3 code
INTEGER fx__dec__DenmReq(BITSTRING& b, LibItsDenm__TestSystem::DenmReq& p)
{
  return -1;
}

INTEGER fx__dec__DenmInd(BITSTRING& b, LibItsDenm__TestSystem::DenmInd& p)
{
  return -1;
}

} //end namespace
