#include "LibItsCam_EncdecDeclarations.hh"
#include "CAMCodec.hh"

namespace LibItsCam__EncdecDeclarations {
/****************************************************
 * @desc    External function to encode a CamReq type
 * @param   value to encode
 * @return  encoded value
 ****************************************************/
BITSTRING fx__enc__CamReq(const LibItsCam__TestSystem::CamReq& p)
{
	return fx__enc__CAM(p.msgOut());
}

/****************************************************
 * @desc    External function to decode a DenmReq type
 * @param   value to encode
 * @return  encoded value
 ****************************************************/
INTEGER fx__dec__CamReq(BITSTRING& b, LibItsCam__TestSystem::CamReq& p)
{
  return -1;
}

INTEGER fx__dec__CamInd(BITSTRING& b, LibItsCam__TestSystem::CamInd& p)
{
	return fx__dec__CAM(b, p.msgIn());
}

BITSTRING fx__enc__CAM(const CAM__PDU__Descriptions::CAM& p)
{
	CAMPDUCodec codec;
	BITSTRING b;
	codec.encode(p, b);
	return b;
}

INTEGER fx__dec__CAM(BITSTRING& b, CAM__PDU__Descriptions::CAM& p)
{
	CAMPDUCodec codec;
	INTEGER rc = codec.decode(b, p);
	if(rc > 0){
		b = (b >> rc);
	}
	return 0;
}

} //end namespace

