#include "Asn1cEncDec.hh"

// basic types
void        titan2asn1c(const INTEGER& t, long& a)
{
	if(t.is_native()){
		a = (int)t;
	}else{
		long long int n = t.get_long_long_val();
		if(n >= LONG_MIN && n <= LONG_MAX){
			a = (long)n;
		}else{
			// TODO: what to do here?
		}
	}
}

void        titan2asn1c(const INTEGER& t, unsigned long& a)
{
	if(t.is_native()){
		int n = (int)t;
		if(n >= 0) {
			a = (unsigned)n;
		}else{
			// TODO: what to do here?
		}
	}else{
		long long int n = t.get_long_long_val();
		if(n >= 0 && n <= (long long int)ULONG_MAX){
			a = (unsigned long)n;
		}else{
			// TODO: what to do here?
		}
	}
}

void        titan2asn1c(const INTEGER& t, INTEGER_t& a) {
	if(t.is_native()){
		asn_long2INTEGER(&a, (int)t);
	}else{
		long long int n = t.get_long_long_val();
		if(n >= LONG_MIN && n <= LONG_MAX){
			asn_long2INTEGER(&a, (long)n);
		}else if(n <= (long long int)ULONG_MAX){
			asn_ulong2INTEGER(&a, (unsigned long)n);
		}else{
			// TODO: what to do here?
		}
	}
}

INTEGER     asn1c2titan(const INTEGER_t& a) {
	long n;
	unsigned long un;
	INTEGER i;

	if( 0 == asn_INTEGER2long(&a, &n)) {
		i.set_long_long_val((long long int)n);
	}else if( 0 == asn_INTEGER2ulong(&a, &un)) {
		i.set_long_long_val((long long int)un);
	}else{
		//TODO: What to do?
	}
	return i;
}

INTEGER     asn1c2titan(long n)
{
	INTEGER i;
	i.set_long_long_val(n);
	return i;
}

INTEGER     asn1c2titan(unsigned long n)
{
	INTEGER i;
	i.set_long_long_val(n);
	return i;
}

void        titan2asn1c(const BOOLEAN& t, BOOLEAN_t& a) {
	a = ((boolean)t) ? 0xFF : 0x00;
}

BOOLEAN     asn1c2titan(const BOOLEAN_t& a) {
	return BOOLEAN(!!a);
}

void        titan2asn1c(const OCTETSTRING& t, OCTET_STRING_t& a) {
	OCTET_STRING_fromBuf(&a, (const char*)(const unsigned char*)t, t.lengthof());
}

OCTETSTRING asn1c2titan(const OCTET_STRING_t& a) {
	return OCTETSTRING(a.size, a.buf);
}

void        titan2asn1c(const BITSTRING& t, BIT_STRING_t& a) {
	int buf_size = (t.lengthof()+7)/8;
	OCTET_STRING_fromBuf((OCTET_STRING_t*)&a, (const char*)(const unsigned char*)t, buf_size);
	a.bits_unused = (buf_size*8) - t.lengthof();
}
BITSTRING   asn1c2titan(const BIT_STRING_t& a) {
	return BITSTRING(a.size*8 - a.bits_unused, a.buf);
}


extern "C" int asn1c_collect_encoded_data(const void *buffer, size_t size, void *application_specific_key)
{
	static const  RAW_coding_par _def_raw_params = {
		ORDER_LSB, /* bitorder */
		ORDER_LSB, /* byteorder */
		ORDER_LSB, /* byteorder */
		ORDER_LSB  /* byteorder */
	};
	TTCN_Buffer * tb = (TTCN_Buffer *)application_specific_key;
	tb->put_b(size, (const unsigned char*)buffer, _def_raw_params, 0);
	return 0;
}
