/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region.shape;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class Vector2d<T> {

	/**
	 * the x value of a 2D-vector (x, y)
	 */
	protected final T x;

	/**
	 * the y value of a 2D-vector (x, y)
	 */
	protected final T y;

	/**
	 * Constructor to create a 2D-vector
	 * 
	 * @param x
	 *            the x value of a 2D-vector (x, y)
	 * @param y
	 *            the y value of a 2D-vector (x, y)
	 * @throws IllegalArgumentException
	 *             if <code>x</code> and/or <code>y</code> is null
	 */
	public Vector2d(T x, T y) {
		if (x == null || y == null) {
			throw new IllegalArgumentException("<x> and <y> may not be null.");
		}
		this.x = x;
		this.y = y;
	}

	/**
	 * @return the x value of a 2D-vector (x, y)
	 */
	public T getX() {
		return x;
	}

	/**
	 * @return the y value of a 2D-vector (x, y)
	 */
	public T getY() {
		return y;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + x.hashCode();
		result = prime * result + y.hashCode();
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Vector2d<?> other = (Vector2d<?>) obj;
		if (!x.equals(other.x))
			return false;
		if (!y.equals(other.y))
			return false;
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Vector2d [x=" + x + ", y=" + y + "]";
	}

}
