package de.fraunhofer.sit.c2x.pki.ca.provider.interfaces;

import de.fraunhofer.sit.c2x.pki.ca.core.interfaces.Service;
import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.Host;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.KnownCA;

/**
 * @author Norbert Bissmeyer (norbert.bissmeyer@sit.fraunhofer.de)
 */
public interface KnownCaProvider extends Service {

	public void updateLoadedX509ClientCerts() throws ProviderException;
	
	public boolean save(Host hostInfo, String caType, byte[] certId, byte[] certificate,
			String x509ClientCert, String rsaClientKey, String rsaClientKeyPassword) throws ProviderException;

	public KnownCA get(byte[] certId) throws ProviderException;

	public KnownCA[] getAll(int offset, int limit) throws ProviderException;

	int removeKnownCA(byte[] certId) throws ProviderException;

	KnownCA[] get(String caType) throws ProviderException;

	KnownCA getKnownRCA() throws ProviderException;
}
