package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Embeddable;

@Embeddable
/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class CrlSeries implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Column(name = Constants.CRL__COL__CRL_SERIES, columnDefinition = "INT UNSIGNED")
	private long crlSeries;

	@Column(name = Constants.CRL__COL__CURRENT_SERIAL, columnDefinition = "INT UNSIGNED")
	private long currentSerial;

	public CrlSeries() {
	}

	public long getCrlSeries() {
		return crlSeries;
	}

	public void setCrlSeries(long crlSeries) {
		this.crlSeries = crlSeries;
	}

	public long getCurrentSerial() {
		return currentSerial;
	}

	public void setCurrentSerial(long currentSerial) {
		this.currentSerial = currentSerial;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (int) (crlSeries ^ (crlSeries >>> 32));
		result = prime * result
				+ (int) (currentSerial ^ (currentSerial >>> 32));
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CrlSeries other = (CrlSeries) obj;
		if (crlSeries != other.crlSeries)
			return false;
		if (currentSerial != other.currentSerial)
			return false;
		return true;
	}

}
