package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.CreationTime;

@Entity
@Table(name = Constants.AUTHENTICATORS__TABLE)
/**
 * @author Norbert Bissmeyer (norbert.bissmeyer@sit.fraunhofer.de)
 */
public class Authenticator implements Serializable, CreationTime {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public Authenticator() {
	}

	@Column(name = Constants.AUTHENTICATORS__COL__CREATION_TIME)
	private Timestamp creationTime;

	@Column(name = Constants.AUTHENTICATORS__COL__COMPANY, columnDefinition = "varchar(50)", nullable = false)
	private String company;

	@Column(name = Constants.AUTHENTICATORS__COL__NAME, columnDefinition = "varchar(50)", nullable = false)
	private String name;

	@Id
	@Column(name = Constants.AUTHENTICATORS__COL__EMAIL, columnDefinition = "varchar(70)", nullable = false)
	private String email;

	@Column(name = Constants.AUTHENTICATORS__COL__TELEPHONE, columnDefinition = "varchar(30)", nullable = false)
	private String telephone;

	@Column(name = Constants.AUTHENTICATORS__COL__ADDRESS, columnDefinition = "varchar(200)", nullable = false)
	private String address;

	@Column(name = Constants.AUTHENTICATORS__COL__CERTIFICATE, columnDefinition = "varchar(20000)", nullable = false)
	private String certificate;

	@Column(name = Constants.AUTHENTICATORS__COL__SUBJECT_ASSURANCE, columnDefinition = "blob", nullable = false)
	private byte[] subjectAssurance;

	@Column(name = Constants.AUTHENTICATORS__COL__ITS_AID_LIST, columnDefinition = "blob", nullable = true)
	private byte[] itsAidList = null;

	@Column(name = Constants.AUTHENTICATORS__COL__ITS_AID_SSP_LIST, columnDefinition = "blob", nullable = true)
	private byte[] itsAidSspList = null;

	@Column(name = Constants.AUTHENTICATORS__COL__PRIORITY_ITS_AID_LIST, columnDefinition = "blob", nullable = true)
	private byte[] priorityItsAidList = null;

	@Column(name = Constants.AUTHENTICATORS__COL__PRIORITY_SSP_LIST, columnDefinition = "blob", nullable = true)
	private byte[] prioritySspList = null;

	@Column(name = Constants.AUTHENTICATORS__COL__IDENTIFIED_REGION, columnDefinition = "blob", nullable = true)
	private byte[] idRegion = null;

	@Column(name = Constants.AUTHENTICATORS__COL__CIRCULAR_REGION, columnDefinition = "blob", nullable = true)
	private byte[] circularRegion = null;

	@Column(name = Constants.HTTP_USER__COL__ID, columnDefinition = "blob", nullable = false)
	private String httpUserId;

	public String getCompany() {
		return company;
	}

	public void setCompany(String company) {
		this.company = company;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getTelephone() {
		return telephone;
	}

	public String getHttpUserId() {
		return httpUserId;
	}

	public void setHttpUserId(String httpUserId) {
		this.httpUserId = httpUserId;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public byte[] getSubjectAssurance() {
		return subjectAssurance;
	}

	public void setSubjectAssurance(byte[] subjectAssurance) {
		this.subjectAssurance = subjectAssurance;
	}

	public byte[] getPrioritySspList() {
		return prioritySspList;
	}

	public void setPrioritySspList(byte[] prioritySspList) {
		this.prioritySspList = prioritySspList;
	}

	public byte[] getItsAidList() {
		return itsAidList;
	}

	public void setItsAidList(byte[] itsAidList) {
		this.itsAidList = itsAidList;
	}

	public byte[] getItsAidSspList() {
		return itsAidSspList;
	}

	public void setItsAidSspList(byte[] itsAidSspList) {
		this.itsAidSspList = itsAidSspList;
	}

	public byte[] getPriorityItsAidList() {
		return priorityItsAidList;
	}

	public void setPriorityItsAidList(byte[] priorityItsAidList) {
		this.priorityItsAidList = priorityItsAidList;
	}

	public byte[] getIdRegion() {
		return idRegion;
	}

	public void setIdRegion(byte[] idRegion) {
		this.idRegion = idRegion;
	}

	public byte[] getCircularRegion() {
		return circularRegion;
	}

	public void setCircularRegion(byte[] circularRegion) {
		this.circularRegion = circularRegion;
	}

	@Override
	public Timestamp getCreationTime() {
		return creationTime;
	}

	@Override
	public void setCreationTime(Timestamp creationTime) {
		this.creationTime = creationTime;
	}

	public String getCertificate() {
		return certificate;
	}

	public X509Certificate getX509Certificate() throws IOException {
		return createdX509FromString(certificate);
	}

	private X509Certificate createdX509FromString(String certificate) throws IOException {
		if (!certificate.contains("-----BEGIN CERTIFICATE-----")
				&& !certificate.contains("-----END CERTIFICATE-----")) {
			throw new IOException("X.509 certificate has wrong format. Certificate must contain "
					+ "\"-----BEGIN CERTIFICATE-----\" and \"-----END CERTIFICATE-----\"");
		}

		X509Certificate x509Cert = null;
		byte[] certificateBytes = certificate.getBytes();
		ByteArrayInputStream bais;
		BufferedInputStream bis;
		try {
			CertificateFactory cf = CertificateFactory.getInstance("X.509");
			bais = new ByteArrayInputStream(certificateBytes);
			bis = new BufferedInputStream(bais);
			while (bis.available() > 0) {
				Certificate cert = cf.generateCertificate(bis);
				if (cert.getType() != "X.509")
					throw new CertificateException("Certificate type " + cert.getType()
							+ " not supported for trust store");
				x509Cert = (X509Certificate) cert;
			}
		} catch (CertificateException e) {
			throw new IOException("Unable to decode X.509 certificate. " + e.getMessage(), e);
		}
		try {
			x509Cert.checkValidity();
		} catch (CertificateException e) {
			throw new IOException("X.509 certificate invalid. " + e.getMessage(), e);
		}
		bais.close();
		bis.close();
		return x509Cert;
	}

	public void setCertificate(String certificate) throws IOException {
		X509Certificate x509Cert = createdX509FromString(certificate);
		if (x509Cert == null)
			throw new IOException("Unable to create X509Certificate with given string");
		this.certificate = certificate;
	}

}