package de.fraunhofer.sit.c2x.pki.ca.measuring;

/**
 * @author Norbert Bissmeyer (norbert.bissmeyer@sit.fraunhofer.de)
 */
public class MeasuringStatisticsEntry {
	private final int numberRequestedElements;
	private final long numberProcesses;
	private final double minTime;
	private final double meanTime;
	private final double maxTime;
	
	public MeasuringStatisticsEntry(int numberRequestedElements, long numberProcesses, double minTime,
			double meanTime, double maxTime) {
		super();
		this.numberRequestedElements = numberRequestedElements;
		this.numberProcesses = numberProcesses;
		this.minTime = minTime;
		this.meanTime = meanTime;
		this.maxTime = maxTime;
	}

	public int getNumberRequestedElements() {
		return numberRequestedElements;
	}

	public long getNumberProcesses() {
		return numberProcesses;
	}

	public double getMinTime() {
		return minTime;
	}

	public double getMeanTime() {
		return meanTime;
	}

	public double getMaxTime() {
		return maxTime;
	}	
}
