/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.crypto.encryption;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.IESParameters;

import de.fraunhofer.sit.c2x.pki.ca.crypto.interfaces.IEncryption;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class ECIES implements IEncryption {

	private CipherParameters privateKey;
	private CipherParameters publicKey;

	public void init(ECPrivateKeyParameters privateKey, ECPublicKeyParameters publicKey) {
		this.privateKey = privateKey;
		this.publicKey = publicKey;
	}

	public void init(CipherParameters privateKey, CipherParameters publicKey) {
		this.privateKey = (ECPrivateKeyParameters) privateKey;
		this.publicKey = (ECPublicKeyParameters) publicKey;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see preserve.pki.ca.crypto.IEncryption#encrypt(byte[])
	 */
	@Override
	public byte[] encrypt(byte[] messageToEncrypt) throws CryptoException {
		if (privateKey == null || publicKey == null) {
			throw new CryptoException("Encryption is not initialized!");
		}
		return iesCrypto(true, privateKey, publicKey, messageToEncrypt);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see preserve.pki.ca.crypto.IEncryption#decrypt(byte[])
	 */
	@Override
	public byte[] decrypt(byte[] cipherToDecrypt) throws CryptoException {
		if (privateKey == null || publicKey == null) {
			throw new CryptoException("Encryption is not initialized!");
		}
		return iesCrypto(false, privateKey, publicKey, cipherToDecrypt);
	}

	private static byte[] iesCrypto(boolean forEncryption, CipherParameters sendersPrivateKey,
			CipherParameters receiversPublicKey, byte[] encoded) throws InvalidCipherTextException {

		ECIESforIEEE1609Dot2 iesEngine = new ECIESforIEEE1609Dot2(new ECDHBasicAgreement(),
				new KDF2BytesGenerator(new SHA256Digest()), new HMac(new SHA256Digest()));

		IESParameters iesParams = new IESParameters(new byte[0], new byte[0], 256);
		iesEngine.init(forEncryption, sendersPrivateKey, receiversPublicKey, iesParams);

		return iesEngine.processBlock(encoded, 0, encoded.length);
	}

}
