package de.fraunhofer.sit.c2x.pki.ca.certificates.datacontainers;

import java.math.BigInteger;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;


public class PsidSspPriorityDataContainer{
	
	protected Long psid = null;
	protected Integer maxPriority = null;
	protected byte[] serviceSpecificPermissions = null;
	
	public void init(Long psid, Integer maxPriority, byte[] serviceSpecificPermissions) {
		this.psid = psid;
		this.maxPriority = maxPriority;
		this.serviceSpecificPermissions = serviceSpecificPermissions;
	}

	public Long getPsid() {
		return psid;
	}

	public void setPsid(Long psid) {
		this.psid = psid;
	}
	
	public void setPsid(BigInteger psid) {
		this.psid = psid.longValue();
	}

	public Integer getMaxPriority() {
		return maxPriority;
	}

	public void setMaxPriority(Integer maxPriority) {
		this.maxPriority = maxPriority;
	}
	
	public void setMaxPriority(BigInteger maxPriority) {
		this.maxPriority = maxPriority.intValue();
	}

	public byte[] getServiceSpecificPermissions() {
		return serviceSpecificPermissions;
	}

	public void setServiceSpecificPermissions(byte[] serviceSpecificPermissions) {
		this.serviceSpecificPermissions = serviceSpecificPermissions;
	}
	
	public void setServiceSpecificPermissions(String serviceSpecificPermissions) throws DecoderException {
		if(serviceSpecificPermissions == null) return;
		this.serviceSpecificPermissions = Hex.decodeHex(serviceSpecificPermissions.toCharArray());
	}
	
	public boolean isPsidOnly(){
		if(psid != null && maxPriority == null && serviceSpecificPermissions == null) return true;
		else return false;
	}
	
	public boolean isPsidSsp(){
		if(psid != null && maxPriority == null && serviceSpecificPermissions != null) return true;
		else return false;
	}
	
	public boolean isPsidMaxPriority(){
		if(psid != null && maxPriority != null && serviceSpecificPermissions == null) return true;
		else return false;
	}
	
	public boolean isPsidMaxPrioritySsp(){
		if(psid != null && maxPriority != null && serviceSpecificPermissions != null) return true;
		else return false;
	}
	
	public boolean isNull(){
		if(psid == null && maxPriority == null && serviceSpecificPermissions == null) return true;
		else return false;
	}
	
}
