/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.DecoderContext;
import com.siemens.ct.exi.context.EncoderContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDIntegerCharacterSet;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.IntegerValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class IntegerDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = -7131847569262739592L;
    private IntegerValue lastInteger;

    public IntegerDatatype(QName schemaType) {
        super(BuiltInType.INTEGER, schemaType);
        this.rcs = new XSDIntegerCharacterSet();
    }

    protected boolean isValidString(String value) {
        this.lastInteger = IntegerValue.parse(value);
        return this.lastInteger != null;
    }

    public boolean isValid(Value value) {
        if (value instanceof IntegerValue) {
            this.lastInteger = (IntegerValue)value;
            return true;
        }
        return this.isValidString(value.toString());
    }

    public void writeValue(EncoderContext encoderContext, QNameContext qnContext, EncoderChannel valueChannel) throws IOException {
        valueChannel.encodeIntegerValue(this.lastInteger);
    }

    public Value readValue(DecoderContext decoderContext, QNameContext qnContext, DecoderChannel valueChannel) throws IOException {
        return valueChannel.decodeIntegerValue();
    }
}

