package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.ca.utils.WaveUtils;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.TrailerFieldTypeImpl.TrailerFieldType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class TrailerField extends WaveElement {

	private TrailerFieldType type;
	private Signature signature;
	private Opaque securityField;

	public TrailerField() {
	}

	public TrailerField(DataInputStream in) throws IOException {
		type = TrailerFieldTypeImpl.getInstance().getEnumType(in.readByte());
		if (type == TrailerFieldType.SIGNATURE) {
			signature = new Signature(in);
		} else {
			securityField = new Opaque(in);
		}
	}

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	public TrailerFieldType getType() {
		return type;
	}

	public Signature getSignature() {
		return signature;
	}

	public Opaque getSecurityField() {
		return securityField;
	}

	public void setType(TrailerFieldType type) {
		this.type = type;
	}

	public void setSignature(Signature signature) {
		this.signature = signature;
	}

	public void setSecurityField(Opaque securityField) {
		this.securityField = securityField;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		int written = TrailerFieldTypeImpl.getInstance().writeData(out, type);
		if (type == TrailerFieldType.SIGNATURE) {
			written += WaveUtils.writeWave(out, signature);
		} else {
			written += WaveUtils.writeWave(out, securityField);
		}
		return written;
	}

}
