/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region;

import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.CircularRegion;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.PolygonalRegion;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.shape.DoubleVector2d;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.shape.LineSegment;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.Convert;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.LinearMath;


/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class PolygonCircleValidator extends AbstractPolygonValidator<CircularRegion> {

	/**
	 * @param polygonalRegion
	 */
	public PolygonCircleValidator(PolygonalRegion polygonalRegion) {
		super(polygonalRegion);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.preserve.pki.ca.validator.Validator#validate(java.lang.Object)
	 */
	@Override
	public boolean validate(CircularRegion regionToValidate) {
		if (regionToValidate == null)
			throw new IllegalArgumentException("<regionToValidate> may not be null");

		DoubleVector2d certCenter = Convert.aTwoDLocation.toVector(regionToValidate.getCenter());
		int certRadius = regionToValidate.getRadiusInt();

		for (LineSegment line : caPolygon.getEdges()) {
			if (Convert.round(LinearMath.distanceBetween(certCenter, line), 0) < certRadius) {
				return false;
			}
		}

		return true;
	}

}
