/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.voip;

import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.protocol.JProtocol;

public abstract class Rtcp
extends JHeader {
    public static final long RTCP_HEADERS_BITMASK = JProtocol.createMaskFromIds(49, 50, 51, 53, 52);
    public static final String DESCRIPTION = "RTP Control Information";
    public static final String RFC = "RFC3550";

    @Field(offset=0, length=2, description="RFC3550")
    public int version() {
        return (super.getByte(0) & 0xC0) >> 6;
    }

    @Field(offset=2, length=1, display="padding")
    public int isPadded() {
        return (super.getByte(0) & 0x20) >> 5;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String typeDescription() {
        return PacketType.valueOf(this.type()).toString().replaceAll("_", " ");
    }

    @Field(offset=8, length=8, display="packet type")
    public int type() {
        return super.getUByte(1);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String lengthDescription() {
        return String.format("(%d +1) * 4 = %d bytes", this.length(), this.length() + 1 << 2);
    }

    @Field(offset=16, length=16, display="packet length")
    public int length() {
        return super.getUShort(2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PacketType {
        SENDER_REPORT(200, "SR"),
        RECEIVER_REPORT(201, "RR"),
        SOURCE_DESCRIPTION(202, "SDES"),
        BYE(203, "BYE"),
        APPLICATION_DEFINED(204, "APP");

        private final int type;
        private final String abr;

        private PacketType(int n2, String string2) {
            this.type = n2;
            this.abr = string2;
        }

        public static PacketType valueOf(int n) {
            for (PacketType packetType : PacketType.values()) {
                if (packetType.type != n) continue;
                return packetType;
            }
            return null;
        }

        public String getAbbreviation() {
            return this.abr;
        }

        public int getPacketType() {
            return this.type;
        }
    }
}

