/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.sigtran;

import java.nio.ByteOrder;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.ProtocolSuite;
import org.jnetpcap.protocol.sigtran.SctpChunk;

@Header(description="Selective Acknowledgement", suite=ProtocolSuite.SIGTRAN, nicname="Sctp-sack")
public class SctpSack
extends SctpChunk {
    public static final int ID = 36;

    @Field(offset=32, length=32, display="Cumulative TSN Ack")
    public long ack() {
        return super.getUInt(4);
    }

    public void ack(long l) {
        super.setUInt(4, l);
    }

    @Field(offset=64, length=32, display="Advertised Receiver Window Credit")
    public long window() {
        return super.getUInt(8);
    }

    public void window(long l) {
        super.setUInt(8, l);
    }

    @Field(offset=96, length=16, display="Number of Gap Ack Blocks")
    public int gapBlockCount() {
        return super.getUShort(12);
    }

    public void gapBlockCount(int n) {
        super.setUShort(12, n);
    }

    @Field(offset=112, length=16, display="Number of Duplicate TSNs")
    public int duplicateTSNCount() {
        return super.getUShort(14);
    }

    public void duplicateTSNCount(int n) {
        super.setUShort(14, n);
    }

    @Field(offset=160, length=0, display="Gap Ack Block", format="%s[]")
    public String[] printGapBlocks() {
        GapBlock[] gapBlockArray = this.gaps();
        String[] stringArray = new String[gapBlockArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = gapBlockArray[i].toString();
        }
        return stringArray;
    }

    @Field(offset=192, length=0, display="Duplicate TSN", format="%s[]")
    public String[] printDuplicateTSNs() {
        long[] lArray = this.duplicates();
        String[] stringArray = new String[lArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Long.toString(lArray[i]);
        }
        return stringArray;
    }

    public GapBlock[] gaps() {
        return this.gaps(new GapBlock[this.gapBlockCount()]);
    }

    public GapBlock[] gaps(GapBlock[] gapBlockArray) {
        int n = this.gapBlockCount();
        for (int i = 0; i < n && i < gapBlockArray.length; ++i) {
            if (gapBlockArray[i] == null) {
                gapBlockArray[i] = new GapBlock(this, 16 + i * 4);
                continue;
            }
            gapBlockArray[i].peer(this, 16 + i * 4, 4);
        }
        return gapBlockArray;
    }

    public long[] duplicates() {
        return this.duplicates(new long[this.duplicateTSNCount()]);
    }

    public long[] duplicates(long[] lArray) {
        int n = this.duplicateTSNCount();
        int n2 = 16 + this.gapBlockCount() * 4;
        for (int i = 0; i < n && i < lArray.length; ++i) {
            lArray[i] = super.getUInt(n2 + i * 4);
        }
        return lArray;
    }

    public static class GapBlock
    extends JBuffer {
        public GapBlock(JBuffer jBuffer, int n) {
            super(JMemory.Type.POINTER);
            this.peer(jBuffer, n, 4);
            this.order(ByteOrder.BIG_ENDIAN);
        }

        public int start() {
            return super.getUShort(0);
        }

        public int end() {
            return super.getUShort(2);
        }

        public String toString() {
            return String.format("[%d - %d]", this.start(), this.end());
        }
    }
}

