/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.lan;

import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.ProtocolSuite;
import org.jnetpcap.protocol.lan.Ethernet;

@Header(length=16, suite=ProtocolSuite.LAN, description="Linux Cooked Capture")
public class SLL
extends JHeader {
    public static final int SLL_HDR_LEN = 16;
    public static final int LINUX_SLL_HOST = 0;
    public static final int LINUX_SLL_BROADCAST = 1;
    public static final int LINUX_SLL_MULTICAST = 2;
    public static final int LINUX_SLL_OTHERHOST = 3;
    public static final int LINUX_SLL_OUTGOING = 4;
    public static int ID = 20;

    @Field(offset=0, length=16)
    public int packetType() {
        return super.getUShort(0);
    }

    @Field(offset=16, length=16)
    public int haType() {
        return super.getUShort(2);
    }

    public HardwareAddressType haTypeEnum() {
        return HardwareAddressType.values()[this.haType()];
    }

    @Field(offset=32, length=16)
    public int haLength() {
        return super.getUShort(4);
    }

    @Dynamic(value=Field.Property.LENGTH)
    public int addressLength() {
        return this.haLength() * 8;
    }

    @Field(offset=48, format="#mac#")
    public byte[] address() {
        return super.getByteArray(6, this.haLength());
    }

    @Field(offset=112, length=16, format="%x")
    public int type() {
        return super.getUShort(14);
    }

    public Ethernet.EthernetType typeEnum() {
        return Ethernet.EthernetType.valueOf(this.type());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HardwareAddressType {
        LINUX_SLL_HOST,
        LINUX_SLL_BROADCAST,
        LINUX_SLL_MULTICAST,
        LINUX_SLL_OTHERHOST,
        LINUX_SLL_OUTGOING;

    }
}

