/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.structure;

import java.util.Arrays;
import java.util.Comparator;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.format.JFormatter;
import org.jnetpcap.packet.structure.AnnotatedField;
import org.jnetpcap.packet.structure.AnnotatedFieldMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JField {
    private static final JFieldComp SORT_BY_OFFSET = new JFieldComp();
    protected JField[] subFields;
    private final String name;
    private final String nicname;
    private JField parent;
    private final JFormatter.Priority priority;
    protected JFormatter.Style style;
    private final AnnotatedFieldMethod value;
    private final AnnotatedFieldMethod offset;
    private final AnnotatedFieldMethod length;
    private final AnnotatedFieldMethod display;
    private final AnnotatedFieldMethod description;
    private final AnnotatedFieldMethod mask;
    private final AnnotatedFieldMethod check;
    private AnnotatedFieldMethod units;

    public static void sortFieldByOffset(JField[] jFieldArray, JHeader jHeader, boolean bl) {
        SORT_BY_OFFSET.setAscending(bl);
        SORT_BY_OFFSET.setHeader(jHeader);
        Arrays.sort(jFieldArray, SORT_BY_OFFSET);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("name=").append(this.name);
        stringBuilder.append(", nicname=").append(this.nicname);
        stringBuilder.append(", parent=").append(this.parent);
        stringBuilder.append(", priority=").append((Object)this.priority);
        stringBuilder.append(", style=").append((Object)this.style);
        return stringBuilder.toString();
    }

    public JField(AnnotatedField annotatedField, JField[] jFieldArray) {
        this.subFields = jFieldArray;
        this.priority = annotatedField.getPriority();
        this.name = annotatedField.getName();
        this.nicname = annotatedField.getNicname();
        annotatedField.getDisplay();
        annotatedField.getUnits();
        this.style = annotatedField.getStyle();
        this.value = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.VALUE);
        this.offset = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.OFFSET);
        this.length = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.LENGTH);
        this.display = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.DISPLAY);
        this.description = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.DESCRIPTION);
        this.mask = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.MASK);
        this.check = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.CHECK);
        this.units = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.UNITS);
        for (JField jField : this.subFields) {
            jField.setParent(this);
        }
    }

    public JField[] getSubFields() {
        return this.subFields;
    }

    public final String getName() {
        return this.name;
    }

    public String getNicname() {
        return this.nicname;
    }

    public final JField getParent() {
        return this.parent;
    }

    public JFormatter.Priority getPriority() {
        return this.priority;
    }

    public JFormatter.Style getStyle() {
        return this.style;
    }

    public boolean hasSubFields() {
        return this.subFields.length != 0;
    }

    public final void setParent(JField jField) {
        this.parent = jField;
    }

    public void setStyle(JFormatter.Style style) {
        this.style = style;
    }

    public String getUnits(JHeader jHeader) {
        return this.units.stringMethod(jHeader, this.name);
    }

    public boolean hasField(JHeader jHeader) {
        return this.check.booleanMethod(jHeader, this.name);
    }

    public String getDisplay(JHeader jHeader) {
        return this.display.stringMethod(jHeader, this.name);
    }

    public int getLength(JHeader jHeader) {
        return this.length.intMethod(jHeader, this.name);
    }

    public long getMask(JHeader jHeader) {
        return this.mask.longMethod(jHeader, this.name);
    }

    public int getOffset(JHeader jHeader) {
        return this.offset.intMethod(jHeader, this.name);
    }

    public String getValueDescription(JHeader jHeader) {
        return this.description.stringMethod(jHeader, this.name);
    }

    public <T> T getValue(Class<T> clazz, JHeader jHeader) {
        return (T)this.value.objectMethod(jHeader, this.name);
    }

    public Object getValue(JHeader jHeader) {
        return this.value.objectMethod(jHeader, this.name);
    }

    public long longValue(JHeader jHeader) {
        Object object = this.getValue(jHeader);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof String) {
            return Long.parseLong(object.toString());
        }
        throw new IllegalStateException("unknown format encountered");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JFieldComp
    implements Comparator<JField> {
        private JHeader header;
        private boolean ascending = true;

        private JFieldComp() {
        }

        @Override
        public int compare(JField jField, JField jField2) {
            if (this.ascending) {
                return jField.getOffset(this.header) - jField2.getOffset(this.header);
            }
            return jField2.getOffset(this.header) - jField.getOffset(this.header);
        }

        public void setHeader(JHeader jHeader) {
            this.header = jHeader;
        }

        public void setAscending(boolean bl) {
            this.ascending = bl;
        }
    }
}

