/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.structure;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jnetpcap.PcapDLT;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JSubHeader;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.FieldSetter;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.structure.AnnotatedField;
import org.jnetpcap.packet.structure.AnnotatedFieldMethod;
import org.jnetpcap.packet.structure.AnnotatedHeaderLengthMethod;
import org.jnetpcap.packet.structure.AnnotatedMethodException;
import org.jnetpcap.packet.structure.HeaderDefinitionError;
import org.jnetpcap.protocol.JProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedHeader {
    private static final Map<Class<?>, AnnotatedHeader> cache = new HashMap();
    private String description;
    private Class<? extends JHeader> clazz;
    private AnnotatedField[] fields;
    private final Header annotation;
    private AnnotatedHeader[] headers;
    private String name;
    private String nicname;
    private Class<? extends JHeader> parentClass = null;
    private AnnotatedHeader parent;

    private static List<Class<?>> getSubHeaderClasses(Class<?> clazz, String string) {
        ArrayList arrayList = new ArrayList();
        for (Class<?> clazz2 : clazz.getClasses()) {
            if (clazz2 == clazz) continue;
            if (clazz2.isAnnotationPresent(Header.class)) {
                arrayList.add(clazz2);
                continue;
            }
            arrayList.addAll(AnnotatedHeader.getSubHeaderClasses(clazz2, string + "." + clazz2.getSimpleName()));
        }
        return arrayList;
    }

    private static AnnotatedHeader inspectHeaderAnnotation(Class<? extends JHeader> clazz, List<HeaderDefinitionError> list) {
        AnnotatedHeader annotatedHeader = new AnnotatedHeader(clazz);
        if (clazz.isAnnotationPresent(Header.class)) {
            Header header = clazz.getAnnotation(Header.class);
            if (!JHeader.class.isAssignableFrom(clazz)) {
                list.add(new HeaderDefinitionError(clazz, "header must subclass 'JHeader'"));
            }
            annotatedHeader.name = header.name().length() != 0 ? header.name() : clazz.getSimpleName();
            annotatedHeader.nicname = header.nicname().length() != 0 ? header.nicname() : annotatedHeader.name;
            annotatedHeader.description = header.description().length() != 0 ? header.description() : (header.dlt().length != 0 ? header.dlt()[0].getDescription() : null);
            if (header.id() != -1) {
                header.id();
            }
            if (header.parent() != JHeader.class) {
                annotatedHeader.parentClass = header.parent();
            }
            if (annotatedHeader.parentClass == null && clazz.getEnclosingClass() != null) {
                for (Class<?> clazz2 = clazz.getEnclosingClass(); clazz2 != null; clazz2 = clazz2.getEnclosingClass()) {
                    if (!clazz2.isAnnotationPresent(Header.class)) continue;
                    if (!JHeader.class.isAssignableFrom(clazz2)) {
                        list.add(new HeaderDefinitionError(clazz, "parentClass header '" + clazz2.getSimpleName() + "' must subclass 'JHeader'"));
                    } else {
                        annotatedHeader.parentClass = clazz2.asSubclass(JHeader.class);
                    }
                    break;
                }
            }
        } else {
            list.add(new HeaderDefinitionError(clazz, "header missing @Header annotation"));
        }
        return annotatedHeader;
    }

    public static AnnotatedHeader inspectJHeaderClass(Class<? extends JHeader> clazz, List<HeaderDefinitionError> list) {
        Object object2;
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        AnnotatedHeader annotatedHeader = AnnotatedHeader.inspectHeaderAnnotation(clazz, list);
        ArrayList<Method> arrayList = new ArrayList<Method>(50);
        ArrayList<Method> arrayList2 = new ArrayList<Method>(50);
        ArrayList<Method> arrayList3 = new ArrayList<Method>(50);
        ArrayList<Method> arrayList4 = new ArrayList<Method>(100);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(arrayList.size());
        for (Class<? extends JHeader> clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            arrayList4.addAll(Arrays.asList(clazz2.getDeclaredMethods()));
        }
        for (Method object22 : arrayList4) {
            if (object22.isAnnotationPresent(Field.class)) {
                arrayList.add(object22);
            }
            if (object22.isAnnotationPresent(Dynamic.class)) {
                arrayList3.add(object22);
                object22.setAccessible(true);
            }
            if (!object22.isAnnotationPresent(FieldSetter.class)) continue;
            arrayList2.add(object22);
        }
        for (Method method : arrayList) {
            try {
                object2 = AnnotatedField.inspectMethod(clazz, method);
                if (hashMap.containsKey(((AnnotatedField)object2).getName())) {
                    throw new HeaderDefinitionError(clazz, "duplicate field " + ((AnnotatedField)object2).getName());
                }
                hashMap.put(((AnnotatedField)object2).getName(), object2);
            }
            catch (HeaderDefinitionError headerDefinitionError) {
                list.add(headerDefinitionError);
            }
        }
        HashMap hashMap2 = new HashMap();
        for (Object object2 : arrayList3) {
            try {
                AnnotatedFieldMethod annotatedFieldMethod = AnnotatedFieldMethod.inspectMethod(object2);
                if (annotatedFieldMethod.method.getParameterTypes().length == 1) {
                    hashMap2.put(annotatedFieldMethod.getFunction(), annotatedFieldMethod);
                    annotatedFieldMethod.setIsMapped(true);
                    continue;
                }
                AnnotatedField annotatedField = (AnnotatedField)hashMap.get(annotatedFieldMethod.getFieldName());
                if (annotatedField == null) {
                    throw new HeaderDefinitionError(clazz, "runtime can not find field " + annotatedFieldMethod.getFieldName());
                }
                annotatedField.getRuntime().setFunction(annotatedFieldMethod);
            }
            catch (HeaderDefinitionError headerDefinitionError) {
                list.add(headerDefinitionError);
            }
        }
        Object var10_14 = null;
        for (Class<?> clazz2 : clazz.getClasses()) {
            Object var10_16 = null;
            if (!clazz2.isAnnotationPresent(Field.class) || !clazz2.isEnum()) continue;
            Field field = clazz2.getAnnotation(Field.class);
            for (Object obj : clazz2.getEnumConstants()) {
                String string = obj.toString().replace('_', '-');
                try {
                    AnnotatedField annotatedField = AnnotatedField.inspectEnumConstant(string, field, hashMap2, clazz);
                    hashMap.put(string, annotatedField);
                }
                catch (AnnotatedMethodException annotatedMethodException) {
                    list.add(annotatedMethodException);
                }
            }
        }
        object2 = hashMap.values().iterator();
        while (object2.hasNext()) {
            AnnotatedField annotatedField = (AnnotatedField)object2.next();
            try {
                if (!annotatedField.isSubField()) continue;
                if (annotatedField.getParent().equals(annotatedField.getName())) {
                    throw new HeaderDefinitionError(clazz, "invalid parentClass name for sub-field " + annotatedField.getName());
                }
                AnnotatedField annotatedField2 = (AnnotatedField)hashMap.get(annotatedField.getParent());
                if (annotatedField2 == null) {
                    throw new HeaderDefinitionError(clazz, "can not find parentClass '" + annotatedField.getParent() + "' for sub field '" + annotatedField.getName() + "'");
                }
                annotatedField2.addSubField(annotatedField);
                object2.remove();
            }
            catch (HeaderDefinitionError headerDefinitionError) {
                list.add(headerDefinitionError);
            }
        }
        for (AnnotatedField annotatedField : hashMap.values()) {
            annotatedField.finishProcessing(list);
        }
        object2 = AnnotatedHeader.getSubHeaderClasses(clazz, clazz.getSimpleName());
        ArrayList<AnnotatedHeader> arrayList5 = new ArrayList<AnnotatedHeader>(object2.size());
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Class clazz3 = (Class)iterator.next();
            if (clazz == clazz3) continue;
            if (!JSubHeader.class.isAssignableFrom(clazz3)) {
                list.add(new HeaderDefinitionError(clazz, "skipping sub-header " + clazz3.getSimpleName() + ". The sub-header must subclass JSubHeader class"));
                continue;
            }
            arrayList5.add(AnnotatedHeader.inspectJHeaderClass(clazz3.asSubclass(JSubHeader.class), list));
        }
        annotatedHeader.saveSubHeaders(arrayList5.toArray(new AnnotatedHeader[arrayList5.size()]));
        annotatedHeader.saveFields(hashMap.values().toArray(new AnnotatedField[hashMap.size()]));
        try {
            AnnotatedHeaderLengthMethod.inspectClass(clazz);
        }
        catch (AnnotatedMethodException annotatedMethodException) {
            list.add(new HeaderDefinitionError(clazz, (Throwable)annotatedMethodException));
        }
        if (list.isEmpty()) {
            cache.put(clazz, annotatedHeader);
        }
        return annotatedHeader;
    }

    private AnnotatedHeader(Class<? extends JHeader> clazz) {
        this.annotation = clazz.getAnnotation(Header.class);
        this.clazz = clazz;
    }

    public AnnotatedField[] getFields() {
        return this.fields;
    }

    public Class<? extends JHeader> getHeaderClass() {
        return this.clazz;
    }

    public final AnnotatedHeader[] getHeaders() {
        return this.headers;
    }

    public int getId() {
        return this.annotation.id();
    }

    public String getName() {
        return this.name;
    }

    public PcapDLT[] getDlt() {
        return this.annotation.dlt();
    }

    public JProtocol.Suite getSuite() {
        return this.annotation.suite();
    }

    public final String getNicname() {
        return this.nicname;
    }

    private void saveFields(AnnotatedField[] annotatedFieldArray) {
        this.fields = annotatedFieldArray;
    }

    private void saveSubHeaders(AnnotatedHeader[] annotatedHeaderArray) {
        this.headers = annotatedHeaderArray;
        for (AnnotatedHeader annotatedHeader : annotatedHeaderArray) {
            annotatedHeader.setParent(this);
        }
    }

    public final AnnotatedHeader getParent() {
        return this.parent;
    }

    public boolean isSubHeader() {
        return this.parent != null;
    }

    private void setParent(AnnotatedHeader annotatedHeader) {
        this.parent = annotatedHeader;
    }

    public String getDescription() {
        return this.description;
    }
}

