/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.UnregisteredHeaderException;
import org.jnetpcap.protocol.JProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JHeaderPool {
    private static JHeaderPool local = new JHeaderPool();
    private ThreadLocal<? extends JHeader>[] locals = new ThreadLocal[64];

    public JHeader getHeader(int n) throws UnregisteredHeaderException {
        return this.getHeader(JRegistry.lookupClass(n), n);
    }

    public <T extends JHeader> T getHeader(JProtocol jProtocol) {
        return (T)this.getHeader(jProtocol.getHeaderClass(), jProtocol.getId());
    }

    public <T extends JHeader> T getHeader(final Class<T> clazz, int n) {
        ThreadLocal threadLocal = this.locals[n];
        if (threadLocal == null) {
            this.locals[n] = threadLocal = new ThreadLocal<T>(){

                @Override
                protected T initialValue() {
                    try {
                        return (JHeader)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException(exception);
                    }
                }
            };
        }
        return (T)threadLocal.get();
    }

    public static JHeaderPool getDefault() {
        return local;
    }
}

