package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.SignerInfoTypeImpl.SignerInfoType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.BiDirectionalMap;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.EnumMapping;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class SignerInfoTypeImpl extends EnumMapping<SignerInfoType> {

	public enum SignerInfoType {
		SELF, CERTIFICATE_DIGEST_WITH_ECDSAP256, CERTIFICATE, CERTIFICATE_CHAIN, CERTIFICATE_DIGEST_WITH_OTHER_ALGORITHM,

		ENCRYPTED, // Not in Standard but used in SMM
		ID; // Not in Standard but used in SMM
	}

	private static SignerInfoTypeImpl instance = null;

	protected SignerInfoTypeImpl() {
	}

	public static SignerInfoTypeImpl getInstance() {
		if (instance == null)
			instance = new SignerInfoTypeImpl();
		return instance;
	}

	@Override
	protected void initMapping(BiDirectionalMap<Integer, SignerInfoType> map) {
		map.put(0, SignerInfoType.SELF);
		map.put(1, SignerInfoType.CERTIFICATE_DIGEST_WITH_ECDSAP256);
		map.put(2, SignerInfoType.CERTIFICATE);
		map.put(3, SignerInfoType.CERTIFICATE_CHAIN);
		map.put(4, SignerInfoType.CERTIFICATE_DIGEST_WITH_OTHER_ALGORITHM);
		map.put(6, SignerInfoType.ENCRYPTED);
		map.put(7, SignerInfoType.ID);
	}

}
