/*************************************************************/
/* Copyright (C) 2016 OSS Nokalva, Inc.  All rights reserved.*/
/*************************************************************/

/* THIS FILE IS PROPRIETARY MATERIAL OF OSS NOKALVA, INC.
 * AND MAY BE USED ONLY BY DIRECT LICENSEES OF OSS NOKALVA, INC.
 * THIS FILE MAY NOT BE DISTRIBUTED.
 * THIS COPYRIGHT STATEMENT MAY NOT BE REMOVED. */

/* Generated for: Testing Technologies IST GmbH, Berlin, Germany - License 11335 on Linux */
/* Abstract syntax: iso_ts_24534-3 */
/* ASN.1 Java project: org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.Libitsivim_asn1 */
/* Created: Tue Jul 26 14:38:15 2016 */
/* ASN.1 Compiler for Java version: 6.2 */
/* ASN.1 compiler options and file names specified:
 * -output org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1 -nolistingfile
 * -nomodlistingfile -constraints -nouserconstraints -valuerefs -debug
 * -nopedantic -noinformatorymessages -uper -root -keepnames -norelaySafe
 * -noparamtypesuperclass -jiaapi -autoencdec -messageFormat emacs
 * /tmp/TTthree-2016.07.26.14.37.28.183/oss7811412611381924702gen/LibItsIvim_asn1.gen
 * asn/ISO_TS_14906_Generic.asn asn/ITS-Container.asn asn/ISO_TS_17419.asn
 * asn/ISO_TS_14906_Application.asn asn/ISO_TS_14816.asn asn/ISO_TS_19321.asn
 * asn/ISO_TS_24534-3.asn
 */


package org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_;

import com.oss.asn1.*;
import com.oss.metadata.*;

/**
 * Define the ASN1 Type VcCode from ASN1 Module IVI_.
 * @see Sequence
 */

public class VcCode extends Sequence {
    
    /**
     * The default constructor.
     */
    public VcCode()
    {
    }
    
    /**
     * Construct with AbstractData components.
     */
    public VcCode(VcClass roadSignClass, INTEGER roadSignCode, 
		    VcOption vcOption, Validity validity, INTEGER value, 
		    RSCUnit unit)
    {
	setRoadSignClass(roadSignClass);
	setRoadSignCode(roadSignCode);
	setVcOption(vcOption);
	setValidity(validity);
	setValue(value);
	setUnit(unit);
    }
    
    /**
     * Construct with components.
     */
    public VcCode(VcClass roadSignClass, long roadSignCode, VcOption vcOption, 
		    Validity validity, long value, RSCUnit unit)
    {
	this(roadSignClass, new INTEGER(roadSignCode), vcOption, validity, 
	     new INTEGER(value), unit);
    }
    
    /**
     * Construct with required components.
     */
    public VcCode(VcClass roadSignClass, long roadSignCode, VcOption vcOption)
    {
	setRoadSignClass(roadSignClass);
	setRoadSignCode(roadSignCode);
	setVcOption(vcOption);
    }
    
    public void initComponents()
    {
	mComponents[0] = new VcClass();
	mComponents[1] = new INTEGER();
	mComponents[2] = new VcOption();
	mComponents[3] = new Validity();
	mComponents[4] = new INTEGER();
	mComponents[5] = new RSCUnit();
    }
    
    // Instance initializer
    {
	mComponents = new AbstractData[6];
    }
    
    // Method to create a specific component instance
    public AbstractData createInstance(int index)
    {
	switch (index) {
	    case 0:
		return new VcClass();
	    case 1:
		return new INTEGER();
	    case 2:
		return new VcOption();
	    case 3:
		return new Validity();
	    case 4:
		return new INTEGER();
	    case 5:
		return new RSCUnit();
	    default:
		throw new InternalError("AbstractCollection.createInstance()");
	}
	
    }
    
    
    // Methods for field "roadSignClass"
    public VcClass getRoadSignClass()
    {
	return (VcClass)mComponents[0];
    }
    
    public void setRoadSignClass(VcClass roadSignClass)
    {
	mComponents[0] = roadSignClass;
    }
    
    
    // Methods for field "roadSignCode"
    public long getRoadSignCode()
    {
	return ((INTEGER)mComponents[1]).longValue();
    }
    
    public void setRoadSignCode(long roadSignCode)
    {
	setRoadSignCode(new INTEGER(roadSignCode));
    }
    
    public void setRoadSignCode(INTEGER roadSignCode)
    {
	mComponents[1] = roadSignCode;
    }
    
    
    // Methods for field "vcOption"
    public VcOption getVcOption()
    {
	return (VcOption)mComponents[2];
    }
    
    public void setVcOption(VcOption vcOption)
    {
	mComponents[2] = vcOption;
    }
    
    
    // Methods for field "validity"
    public Validity getValidity()
    {
	return (Validity)mComponents[3];
    }
    
    public void setValidity(Validity validity)
    {
	mComponents[3] = validity;
    }
    
    public boolean hasValidity()
    {
	return componentIsPresent(3);
    }
    
    public void deleteValidity()
    {
	setComponentAbsent(3);
    }
    
    
    
    /**
     * Define the ASN1 Type Validity from ASN1 Module IVI_.
     * @see SequenceOf
     */
    public static class Validity extends SequenceOf {
	
	/**
	 * The default constructor.
	 */
	public Validity()
	{
	}
	
	/**
	 * Construct from an array of components.
	 */
	public Validity(DTM[] elements)
	{
	    super(elements);
	}
	
	/**
	 * Add an Element to the SEQUENCE OF/SET OF.
	 */
	public synchronized void add(DTM element)
	{
	    super.addElement(element);
	}
	
	/**
	 * Set an Element in the SEQUENCE OF/SET OF.
	 */
	public synchronized void set(DTM element, int atIndex)
	{
	    super.setElement(element, atIndex);
	}
	
	/**
	 * Get an Element from the SEQUENCE OF/SET OF.
	 */
	public synchronized DTM get(int atIndex)
	{
	    return (DTM)super.getElement(atIndex);
	}
	
	/**
	 * Insert an Element into the SEQUENCE OF/SET OF.
	 */
	public synchronized void insert(DTM element, int atIndex)
	{
	    super.insertElement(element, atIndex);
	}
	
	/**
	 * Remove an Element from the SEQUENCE OF/SET OF.
	 */
	public synchronized void remove(DTM element)
	{
	    super.removeElement(element);
	}
	
	/**
	 * Create an instance of  SEQUENCE OF/SET OF.
	 */
	public AbstractData createInstance()
	{
	    return (AbstractData)new DTM();
	}
	
	/**
	 * Initialize the type descriptor.
	 */
	private static final ContainerInfo c_typeinfo = new ContainerInfo (
	    new Tags (
		new short[] {
		    (short)0x8003
		}
	    ),
	    new QName (
		"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
		"VcCode$Validity"
	    ),
	    new QName (
		"builtin",
		"SEQUENCE OF"
	    ),
	    274462,
	    new ExtensibleConstraint (
		new SizeConstraint (
		    new ValueRangeConstraint (
			new AbstractBounds(
			    new com.oss.asn1.INTEGER(1), 
			    new com.oss.asn1.INTEGER(8),
			    0
			)
		    )
		),
		null
	    ),
	    new Bounds (
		new java.lang.Long(1),
		new java.lang.Long(8)
	    ),
	    new TypeInfoRef (
		new QName (
		    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
		    "DTM"
		)
	    )
	);
	
	/**
	 * Get the type descriptor (TypeInfo) of 'this' Validity object.
	 */
	public TypeInfo getTypeInfo()
	{
	    return c_typeinfo;
	}
	
	/**
	 * Get the static type descriptor (TypeInfo) of 'this' Validity object.
	 */
	public static TypeInfo getStaticTypeInfo()
	{
	    return c_typeinfo;
	}
	
    } // End class definition for Validity

    // Methods for field "value"
    public long getValue()
    {
	return ((INTEGER)mComponents[4]).longValue();
    }
    
    public void setValue(long value)
    {
	setValue(new INTEGER(value));
    }
    
    public void setValue(INTEGER value)
    {
	mComponents[4] = value;
    }
    
    public boolean hasValue()
    {
	return componentIsPresent(4);
    }
    
    public void deleteValue()
    {
	setComponentAbsent(4);
    }
    
    
    // Methods for field "unit"
    public RSCUnit getUnit()
    {
	return (RSCUnit)mComponents[5];
    }
    
    public void setUnit(RSCUnit unit)
    {
	mComponents[5] = unit;
    }
    
    public boolean hasUnit()
    {
	return componentIsPresent(5);
    }
    
    public void deleteUnit()
    {
	setComponentAbsent(5);
    }
    
    
    /**
     * Initialize the type descriptor.
     */
    private static final SequenceInfo c_typeinfo = new SequenceInfo (
	new Tags (
	    new short[] {
		0x0010
	    }
	),
	new QName (
	    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
	    "VcCode"
	),
	new QName (
	    "IVI",
	    "VcCode"
	),
	274458,
	null,
	new Fields (
	    new SequenceFieldInfo[] {
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8000
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
				"VcClass"
			    ),
			    new QName (
				"IVI",
				"VcClass"
			    ),
			    274458,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new VcClass(0), 
				    new VcClass(7),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(0),
				new java.lang.Long(7)
			    ),
			    new MemberList (
				new MemberListElement[] {
				    new MemberListElement (
					"classA",
					0
				    ),
				    new MemberListElement (
					"classB",
					1
				    ),
				    new MemberListElement (
					"classC",
					2
				    ),
				    new MemberListElement (
					"classD",
					3
				    ),
				    new MemberListElement (
					"classE",
					4
				    ),
				    new MemberListElement (
					"classF",
					5
				    ),
				    new MemberListElement (
					"classG",
					6
				    ),
				    new MemberListElement (
					"classH",
					7
				    )
				}
			    )
			)
		    ),
		    "roadSignClass",
		    0,
		    2,
		    null
		),
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8001
				}
			    ),
			    new QName (
				"com.oss.asn1",
				"INTEGER"
			    ),
			    new QName (
				"builtin",
				"INTEGER"
			    ),
			    274458,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new com.oss.asn1.INTEGER(1), 
				    new com.oss.asn1.INTEGER(64),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(1),
				new java.lang.Long(64)
			    ),
			    null
			)
		    ),
		    "roadSignCode",
		    1,
		    2,
		    null
		),
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8002
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
				"VcOption"
			    ),
			    new QName (
				"IVI",
				"VcOption"
			    ),
			    274458,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new VcOption(0), 
				    new VcOption(7),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(0),
				new java.lang.Long(7)
			    ),
			    new MemberList (
				new MemberListElement[] {
				    new MemberListElement (
					"none",
					0
				    ),
				    new MemberListElement (
					"a",
					1
				    ),
				    new MemberListElement (
					"b",
					2
				    ),
				    new MemberListElement (
					"c",
					3
				    ),
				    new MemberListElement (
					"d",
					4
				    ),
				    new MemberListElement (
					"e",
					5
				    ),
				    new MemberListElement (
					"f",
					6
				    ),
				    new MemberListElement (
					"g",
					7
				    )
				}
			    )
			)
		    ),
		    "vcOption",
		    2,
		    2,
		    null
		),
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new QName (
			    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
			    "VcCode$Validity"
			)
		    ),
		    "validity",
		    3,
		    3,
		    null
		),
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8004
				}
			    ),
			    new QName (
				"com.oss.asn1",
				"INTEGER"
			    ),
			    new QName (
				"builtin",
				"INTEGER"
			    ),
			    274458,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new com.oss.asn1.INTEGER(0), 
				    new com.oss.asn1.INTEGER(65535),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(0),
				new java.lang.Long(65535)
			    ),
			    null
			)
		    ),
		    "value",
		    4,
		    3,
		    null
		),
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8005
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
				"RSCUnit"
			    ),
			    new QName (
				"IVI",
				"RSCUnit"
			    ),
			    274458,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new RSCUnit(0), 
				    new RSCUnit(15),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(0),
				new java.lang.Long(15)
			    ),
			    new MemberList (
				new MemberListElement[] {
				    new MemberListElement (
					"kmperh",
					0
				    ),
				    new MemberListElement (
					"milesperh",
					1
				    ),
				    new MemberListElement (
					"kilometer",
					2
				    ),
				    new MemberListElement (
					"meter",
					3
				    ),
				    new MemberListElement (
					"decimeter",
					4
				    ),
				    new MemberListElement (
					"centimeter",
					5
				    ),
				    new MemberListElement (
					"mile",
					6
				    ),
				    new MemberListElement (
					"yard",
					7
				    ),
				    new MemberListElement (
					"foot",
					8
				    ),
				    new MemberListElement (
					"minutesOfTime",
					9
				    ),
				    new MemberListElement (
					"tonnes",
					10
				    ),
				    new MemberListElement (
					"hundredkg",
					11
				    ),
				    new MemberListElement (
					"pound",
					12
				    ),
				    new MemberListElement (
					"rateOfIncline",
					13
				    )
				}
			    )
			)
		    ),
		    "unit",
		    5,
		    3,
		    null
		)
	    }
	),
	0,
	new TagDecoders (
	    new TagDecoder[] {
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8000, 0)
		    }
		),
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8001, 1)
		    }
		),
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8002, 2)
		    }
		),
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8003, 3),
			new TagDecoderElement((short)0x8004, 4),
			new TagDecoderElement((short)0x8005, 5)
		    }
		),
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8004, 4),
			new TagDecoderElement((short)0x8005, 5)
		    }
		),
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8005, 5)
		    }
		)
	    }
	),
	0
    );
    
    /**
     * Get the type descriptor (TypeInfo) of 'this' VcCode object.
     */
    public TypeInfo getTypeInfo()
    {
	return c_typeinfo;
    }
    
    /**
     * Get the static type descriptor (TypeInfo) of 'this' VcCode object.
     */
    public static TypeInfo getStaticTypeInfo()
    {
	return c_typeinfo;
    }
    
} // End class definition for VcCode
