package de.fraunhofer.sit.c2x.pki.ca.validator.pseudonym;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

import de.fraunhofer.sit.c2x.pki.ca.validator.pseudonym.intervaltree.Interval;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class PPEResult {

	private final int number;
	private final Set<Interval<Integer>> set;
	private final long plt;

	public PPEResult(int number,long plt, Set<Interval<Integer>> set) {
		this.number = number;
		this.plt = plt;
		this.set = set;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + number;
		result = prime * result + ((set == null) ? 0 : set.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		PPEResult other = (PPEResult) obj;
		if (number != other.number)
			return false;
		if (set == null) {
			if (other.set != null)
				return false;
		} else if (!set.equals(other.set))
			return false;
		return true;
	}
	
	public int getNumber() {
		return number;
	}

	public Set<Interval<Integer>> getSet() {
		return set;
	}
	
	public Set<Interval<Integer>> getSingleIntervals() {
		
		Set<Interval<Integer>> ret = new HashSet<>();
		for (Interval<Integer> interval : set) {
			long i = interval.getStart();
			while(i < interval.getEnd()) {
				ret.add(new Interval<Integer>(i, i+plt, interval.getData()));
				i+=plt;
			}
		}
		Set<Interval<Integer>> ret2 = new TreeSet<Interval<Integer>>(new Comparator<Interval<Integer>>() {
			@Override
			public int compare(Interval<Integer> o1, Interval<Integer> o2) {
				return Long.compare(o1.getStart(), o2.getStart());
			}
		});
		ret2.addAll(ret);
		return ret2;
		
	}

	@Override
	public String toString() {
		return "PPEResult [number=" + number + ", plt=" + plt + "]";
	}
	
	
	
	
}
