package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.CreationTime;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
@Entity
@Table(name = Constants.SLOT__TABLE)
public class DBInterval implements CreationTime {

	@EmbeddedId
	private DBIntervalId id;

	@Column(name = Constants.SLOT__COL__CREATION_TIME, nullable = false)
	private Timestamp creationTime;

	@Column(name = Constants.SLOT__COL__REQUEST_HASH, nullable = false, columnDefinition = "varbinary(32)")
	private byte[] requestHash;

	@Column(name = Constants.SLOT__COL__ACTIVATED_CERTS)
	private long activatedCerts;

	@Column(name = Constants.SLOT__COL__RESERVED)
	private long reservedCerts;

	@Override
	public void setCreationTime(Timestamp creationTime) {
		this.creationTime = creationTime;
	}

	@Override
	public Timestamp getCreationTime() {
		return creationTime;
	}

	public DBIntervalId getId() {
		return id;
	}

	public void setId(DBIntervalId id) {
		this.id = id;
	}

	public long getActivatedCerts() {
		return activatedCerts;
	}

	public void setActivatedCerts(long activatedCerts) {
		this.activatedCerts = activatedCerts;
	}

	public long getReservedCerts() {
		return reservedCerts;
	}

	public void setReservedCerts(long reservedCerts) {
		this.reservedCerts = reservedCerts;
	}

	public byte[] getRequestHash() {
		return requestHash;
	}

	public void setRequestHash(byte[] requestHash) {
		this.requestHash = requestHash;
	}

}
