/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.network;

import org.jnetpcap.packet.JSubHeader;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.protocol.network.Rip;

public class Rip1
extends Rip {
    private EntryV1[] routingTable;

    protected void decodeHeader() {
        super.decodeHeader();
        this.routingTable = null;
    }

    private void decodeRoutingTable() {
        this.routingTable = new EntryV1[this.count];
        for (int i = 0; i < this.count; ++i) {
            EntryV1 entryV1;
            this.routingTable[i] = entryV1 = new EntryV1();
            entryV1.peer(this, 4 + i * 20, 20);
        }
    }

    @Field(offset=32, format="%RIP")
    public EntryV1[] routingTable() {
        if (this.routingTable == null) {
            this.decodeRoutingTable();
        }
        return this.routingTable;
    }

    @Dynamic(value=Field.Property.LENGTH)
    public int routingTableLength() {
        return this.count * 20 * 8;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Header
    public static class EntryV1
    extends JSubHeader<Rip1> {
        @Field(offset=32, length=32)
        public byte[] address() {
            return super.getByteArray(4, 4);
        }

        @Field(offset=0, length=16)
        public int family() {
            return super.getUShort(0);
        }

        @Field(offset=128, length=32)
        public int metric() {
            return super.getInt(16);
        }
    }
}

