/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.application;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.annotate.Bind;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;
import org.jnetpcap.packet.annotate.ProtocolSuite;
import org.jnetpcap.protocol.application.HtmlParser;
import org.jnetpcap.protocol.tcpip.Http;
import org.jnetpcap.util.JThreadLocal;

@Header(nicname="Html", suite=ProtocolSuite.APPLICATION)
public class Html
extends JHeader {
    private String page;
    private static final JThreadLocal<StringBuilder> stringLocal = new JThreadLocal<StringBuilder>(StringBuilder.class);
    private static final JThreadLocal<HtmlParser> parserLocal = new JThreadLocal<HtmlParser>(HtmlParser.class);
    private HtmlTag[] tags;
    private HtmlTag[] links;

    @Bind(to=Http.class, stringValue={"text/html"})
    public static boolean bind2Http(JPacket jPacket, Http http) {
        return http.hasContentType() && http.contentType().startsWith("text/html;");
    }

    @Bind(to=Http.class, stringValue={"text/css"})
    public static boolean bind2HttpAsCSS(JPacket jPacket, Http http) {
        return http.hasContentType() && http.contentType().startsWith("text/css;");
    }

    @HeaderLength
    public static int headerLength(JBuffer jBuffer, int n) {
        return jBuffer.size() - n;
    }

    protected void decodeHeader() {
        StringBuilder stringBuilder = (StringBuilder)stringLocal.get();
        stringBuilder.setLength(0);
        super.getUTF8String(0, stringBuilder, this.size());
        this.page = stringBuilder.toString();
        this.tags = null;
        this.links = null;
    }

    @Field(offset=0, format="#textdump#")
    public String page() {
        return this.page;
    }

    @Dynamic(value=Field.Property.LENGTH)
    public int pageLength() {
        return this.size() * 8;
    }

    public HtmlTag[] tags() {
        if (this.tags == null) {
            this.tags = ((HtmlParser)parserLocal.get()).decodeAllTags(this.page);
        }
        return this.tags;
    }

    public HtmlTag[] links() {
        if (this.links == null) {
            this.links = ((HtmlParser)parserLocal.get()).decodeLinks(this.tags());
        }
        return this.links;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (HtmlTag htmlTag : this.tags()) {
            stringBuilder.append(htmlTag.toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tag {
        A(new String[0]),
        B(new String[0]),
        BODY(new String[0]),
        BUTTON(new String[0]),
        CAPTION(new String[0]),
        CENTER(new String[0]),
        DIV(new String[0]),
        EM(new String[0]),
        FORM(new String[0]),
        H1(new String[0]),
        H2(new String[0]),
        H3(new String[0]),
        H4(new String[0]),
        H5(new String[0]),
        H6(new String[0]),
        HEAD(new String[0]),
        HTML(new String[0]),
        I(new String[0]),
        IFRAME(new String[0]),
        IMG(new String[0]),
        INPUT(new String[0]),
        LABEL(new String[0]),
        LI(new String[0]),
        LINK("rel", "type", "href"),
        META(new String[0]),
        NOSCRIPT(new String[0]),
        OBJECT(new String[0]),
        OL(new String[0]),
        P(new String[0]),
        REL(new String[0]),
        SCRIPT(new String[0]),
        SPAN(new String[0]),
        TABLE(new String[0]),
        TBODY(new String[0]),
        TD(new String[0]),
        TEXT(new String[0]),
        TH(new String[0]),
        TITLE(new String[0]),
        TR(new String[0]),
        U(new String[0]),
        UL(new String[0]),
        UNKNOWN(new String[0]);

        private final String[] params;

        public static Tag parseStringPrefix(String string) {
            for (Tag tag : Tag.values()) {
                if (!string.toUpperCase().startsWith(tag.name())) continue;
                return tag;
            }
            return UNKNOWN;
        }

        private Tag(String ... stringArray) {
            int n2 = 0;
            for (String string2 : stringArray) {
                stringArray[n2++] = string2.trim().toUpperCase();
            }
            this.params = stringArray;
        }

        public final String[] getParams() {
            return this.params;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Param {
            ALT,
            CLASS,
            HEIGHT,
            HREF,
            ID,
            SRC,
            TITLE,
            TYPE,
            UNKNOWN,
            WIDTH;


            public static Param parseStringPrefix(String string) {
                for (Param param : Param.values()) {
                    if (!string.toUpperCase().startsWith(param.name())) continue;
                    return param;
                }
                return UNKNOWN;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HtmlTag {
        private final int end;
        private Map<Tag.Param, String> params = Collections.emptyMap();
        private final String source;
        private final int start;
        private Tag tag;
        private final String tagString;
        final Type type;

        public HtmlTag(Tag tag, Type type, String string, String string2, int n, int n2) {
            this.tag = tag;
            this.type = type;
            this.tagString = string;
            this.source = string2;
            this.start = n;
            this.end = n2;
            if (type != Type.ATOMIC) {
                this.parseTag(tag, string);
            }
        }

        public final int getEnd() {
            return this.end;
        }

        public final Map<Tag.Param, String> getParams() {
            return this.params;
        }

        public final String getSource() {
            return this.source;
        }

        public final int getStart() {
            return this.start;
        }

        public final Tag getTag() {
            return this.tag;
        }

        public String getTagString() {
            return this.tagString;
        }

        public final Type getType() {
            return this.type;
        }

        private void parseTag(Tag tag, String string) {
            String[] stringArray = string.split(" ");
            if (stringArray.length > 1) {
                this.params = new HashMap<Tag.Param, String>(stringArray.length - 1);
            }
            for (String string2 : stringArray) {
                String[] stringArray2 = (string2 = string2.trim()).split("=");
                if (stringArray2.length != 2) continue;
                if (stringArray2[1].charAt(0) == '\"' || stringArray2[1].charAt(0) == '\"') {
                    stringArray2[1] = stringArray2[1].substring(1, stringArray2[1].length() - 2);
                }
                this.params.put(Tag.Param.parseStringPrefix(stringArray2[0]), stringArray2[1]);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            switch (this.type) {
                case ATOMIC: {
                    break;
                }
                case CLOSE: {
                    stringBuilder.append(this.tag.name()).append("/>");
                    break;
                }
                case OPEN: {
                    stringBuilder.append(this.tag.name()).append('<');
                }
            }
            if (this.tag == Tag.TEXT) {
                stringBuilder.append('\"');
                stringBuilder.append(((HtmlParser)parserLocal.get()).format(this.tagString));
                stringBuilder.append('\"');
            } else if (!this.params.isEmpty()) {
                stringBuilder.append('=');
                stringBuilder.append(this.params.toString());
            }
            return stringBuilder.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            ATOMIC,
            CLOSE,
            OPEN;

        }
    }
}

