/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.structure;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.JScan;
import org.jnetpcap.packet.annotate.Scanner;
import org.jnetpcap.packet.structure.AnnotatedMethod;
import org.jnetpcap.packet.structure.AnnotatedMethodException;
import org.jnetpcap.packet.structure.HeaderDefinitionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedScannerMethod
extends AnnotatedMethod {
    private static final Map<Class<?>, AnnotatedScannerMethod[]> cache = new HashMap();
    private final int id;

    public static AnnotatedScannerMethod[] inspectJHeaderClass(Class<? extends JHeader> clazz) {
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        Method[] methodArray = AnnotatedScannerMethod.getMethods(clazz, Scanner.class);
        if (methodArray.length > 1) {
            throw new HeaderDefinitionError(clazz, "too many scanners defined");
        }
        if (methodArray.length == 1) {
            AnnotatedScannerMethod[] annotatedScannerMethodArray = new AnnotatedScannerMethod[]{new AnnotatedScannerMethod(methodArray[0], clazz)};
            cache.put(clazz, annotatedScannerMethodArray);
            return annotatedScannerMethodArray;
        }
        AnnotatedScannerMethod[] annotatedScannerMethodArray = new AnnotatedScannerMethod[]{};
        cache.put(clazz, annotatedScannerMethodArray);
        return annotatedScannerMethodArray;
    }

    public static AnnotatedScannerMethod[] inspectClass(Class<? extends JHeader> clazz) {
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        ArrayList<AnnotatedScannerMethod> arrayList = new ArrayList<AnnotatedScannerMethod>(20);
        for (Method method : AnnotatedScannerMethod.getMethods(clazz, Scanner.class)) {
            Class<? extends JHeader> clazz2;
            Scanner scanner = method.getAnnotation(Scanner.class);
            Class<? extends JHeader> clazz3 = clazz2 = scanner.value() == JHeader.class ? clazz : scanner.value();
            if (!JHeader.class.isAssignableFrom(clazz)) {
                throw new HeaderDefinitionError(clazz, "non JHeader based classes, must declare protocol class in @Scanner annotation");
            }
            arrayList.add(new AnnotatedScannerMethod(method, clazz2));
        }
        Object[] objectArray = arrayList.toArray(new AnnotatedScannerMethod[arrayList.size()]);
        cache.put(clazz, (AnnotatedScannerMethod[])objectArray);
        return objectArray;
    }

    public static AnnotatedScannerMethod[] inspectObject(Object object) {
        Class<?> clazz = object.getClass();
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        ArrayList<AnnotatedScannerMethod> arrayList = new ArrayList<AnnotatedScannerMethod>(20);
        for (Method method : AnnotatedScannerMethod.getMethods(clazz, Scanner.class)) {
            Scanner scanner = method.getAnnotation(Scanner.class);
            if (scanner.value() == JHeader.class) {
                throw new HeaderDefinitionError(clazz, "non JHeader based classes, must declare protocol class in @Scanner annotation");
            }
            arrayList.add(new AnnotatedScannerMethod(method, scanner.value(), object));
        }
        Object[] objectArray = arrayList.toArray(new AnnotatedScannerMethod[arrayList.size()]);
        cache.put(clazz, (AnnotatedScannerMethod[])objectArray);
        return objectArray;
    }

    private AnnotatedScannerMethod(Method method, Class<? extends JHeader> clazz) {
        super(method);
        this.id = JRegistry.lookupId(clazz);
    }

    public AnnotatedScannerMethod(Method method, Class<? extends JHeader> clazz, Object object) {
        super(method, object);
        this.id = JRegistry.lookupId(clazz);
    }

    public void scan(JScan jScan) {
        try {
            this.method.invoke(this.object, jScan);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AnnotatedMethodException(this.declaringClass, (Throwable)invocationTargetException);
        }
    }

    @Override
    protected void validateSignature(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (!method.isAnnotationPresent(Scanner.class)) {
            throw new AnnotatedMethodException(clazz, "@Scanner annotation missing for " + method.getName() + "()");
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1 || classArray[0] != JScan.class) {
            throw new AnnotatedMethodException(clazz, "Invalid signature for " + method.getName() + "()");
        }
        if (this.object == null && (method.getModifiers() & 8) == 0) {
            throw new AnnotatedMethodException(clazz, method.getName() + "()" + " must be declared static");
        }
    }

    public int getId() {
        return this.id;
    }
}

