/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotatedMethod {
    protected final Method method;
    protected boolean isMapped = false;
    protected final Class<?> declaringClass;
    protected final Object object;
    private static HashMap<Integer, Method[]> cache = new HashMap(20);

    public void setIsMapped(boolean bl) {
        this.isMapped = bl;
    }

    public AnnotatedMethod() {
        this.method = null;
        this.declaringClass = null;
        this.object = null;
        this.isMapped = false;
    }

    public AnnotatedMethod(Method method, Object object) {
        this.object = object;
        this.method = method;
        this.declaringClass = method.getDeclaringClass();
    }

    public AnnotatedMethod(Method method) {
        this.method = method;
        this.declaringClass = method.getDeclaringClass();
        this.object = null;
        this.validateSignature(method);
    }

    public Method getMethod() {
        return this.method;
    }

    protected abstract void validateSignature(Method var1);

    public String toString() {
        if (this.method == null) {
            return "";
        }
        return this.declaringClass.getSimpleName() + "." + this.method.getName() + "()";
    }

    public static Method[] getMethods(Class<?> clazz, Class<? extends Annotation> clazz2) {
        int n = clazz.hashCode() + clazz2.hashCode();
        if (cache.containsKey(n)) {
            return cache.get(n);
        }
        ArrayList<Method> arrayList = new ArrayList<Method>(50);
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(clazz2)) continue;
            arrayList.add(method);
        }
        Method[] methodArray = arrayList.toArray(new Method[arrayList.size()]);
        cache.put(n, methodArray);
        return methodArray;
    }
}

