/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.structure;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.structure.AnnotatedField;
import org.jnetpcap.packet.structure.AnnotatedFieldMethod;
import org.jnetpcap.packet.structure.HeaderDefinitionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedFieldRuntime {
    private final Map<Field.Property, AnnotatedFieldMethod> map = new HashMap<Field.Property, AnnotatedFieldMethod>();
    private final AnnotatedField parent;

    public AnnotatedFieldRuntime(AnnotatedField annotatedField) {
        this.parent = annotatedField;
    }

    public void finishProcessing(List<HeaderDefinitionError> list) {
        for (Field.Property property : Field.Property.values()) {
            try {
                if (this.map.containsKey((Object)property)) continue;
                this.map.put(property, AnnotatedFieldMethod.generateFunction(property, this.parent));
            }
            catch (HeaderDefinitionError headerDefinitionError) {
                list.add(headerDefinitionError);
            }
        }
    }

    public Map<Field.Property, AnnotatedFieldMethod> getFunctionMap() {
        return this.map;
    }

    public void setFunction(AnnotatedFieldMethod annotatedFieldMethod) {
        Field.Property property = annotatedFieldMethod.getFunction();
        if (this.map.containsKey((Object)property)) {
            throw new HeaderDefinitionError(annotatedFieldMethod.getMethod().getDeclaringClass(), "duplicate " + (Object)((Object)property) + " method declarations for field " + this.parent.getName());
        }
        if (!annotatedFieldMethod.isMapped) {
            annotatedFieldMethod.configFromField(this.parent);
        }
        this.map.put(property, annotatedFieldMethod);
    }

    public void setFunction(Map<Field.Property, AnnotatedFieldMethod> map) {
        for (AnnotatedFieldMethod annotatedFieldMethod : map.values()) {
            this.setFunction(annotatedFieldMethod);
        }
    }
}

