/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.nio;

import java.nio.ByteBuffer;
import java.sql.Time;
import java.util.Properties;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.nio.JNumber;

public class JMemoryPool {
    private static final int BUS_WIDTH = JNumber.Type.INT.size;
    public static final int DEFAULT_BLOCK_SIZE = 32768;
    private static JMemoryPool defaultPool;
    private Block block;
    private int blockSize;

    public static JBuffer buffer(int n) {
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        JMemoryPool.defaultMemoryPool().allocate(n, jBuffer);
        return jBuffer;
    }

    public static void malloc(int n, JMemory jMemory) {
        JMemoryPool.defaultMemoryPool().allocate(n, jMemory);
    }

    public JMemoryPool() {
        this.blockSize = this.getBlockSize();
    }

    public JMemoryPool(int n) {
        this.blockSize = n;
    }

    public synchronized void allocate(int n, JMemory jMemory) {
        Block block = this.getBlock(n);
        int n2 = block.allocate(n);
        jMemory.peer(block, n2, n);
    }

    public JMemory allocateExclusive(int n) {
        return new JMemory(n){};
    }

    public synchronized int duplicate(JMemory jMemory, JMemory jMemory2) {
        Block block = this.getBlock(jMemory.size);
        int n = block.allocate(jMemory.size);
        jMemory.transferTo(block, 0, jMemory.size, n);
        jMemory2.peer(block, n, jMemory.size);
        return jMemory.size;
    }

    public synchronized int duplicate2(JMemory jMemory, JMemory jMemory2, JMemory jMemory3, JMemory jMemory4) {
        int n = jMemory.size;
        int n2 = jMemory2.size;
        int n3 = jMemory.size + jMemory2.size;
        Block block = this.getBlock(n3);
        int n4 = block.allocate(n3);
        int n5 = jMemory.transferTo(block, 0, n, n4);
        jMemory2.transferTo(block, 0, n2, n4 + n5);
        jMemory3.peer(block, n4, n);
        jMemory4.peer(block, n4 + n5, n2);
        return n3;
    }

    public synchronized int duplicate2(JMemory jMemory, ByteBuffer byteBuffer, JMemory jMemory2, JMemory jMemory3) {
        int n = jMemory.size;
        int n2 = byteBuffer.limit() - byteBuffer.position();
        int n3 = n + n2;
        Block block = this.getBlock(n3);
        int n4 = block.allocate(n3);
        int n5 = jMemory.transferTo(block, 0, n, n4);
        block.transferFrom(byteBuffer, n4 + n5);
        jMemory2.peer(block, n4, n);
        jMemory3.peer(block, n4 + n5, n2);
        return n3;
    }

    public synchronized int duplicate(ByteBuffer byteBuffer, JMemory jMemory) {
        int n = byteBuffer.limit() - byteBuffer.position();
        Block block = this.getBlock(n);
        int n2 = block.allocate(n);
        block.transferFrom(byteBuffer, n2);
        jMemory.peer(block, n2, n);
        return n;
    }

    public Block getBlock(int n) {
        n += n % BUS_WIDTH;
        if (this.block == null || this.block.available < n) {
            this.block = this.newBlock(n);
        }
        return this.block;
    }

    private Block newBlock(int n) {
        return new Block(n > this.blockSize ? n : this.blockSize);
    }

    public static JMemoryPool defaultMemoryPool() {
        if (defaultPool == null) {
            defaultPool = new JMemoryPool();
        }
        return defaultPool;
    }

    public static void shutdown() {
        if (defaultPool != null) {
            JMemoryPool.defaultPool.block = null;
            defaultPool = null;
        }
    }

    public int getBlockSize() {
        if (this.blockSize != 0) {
            return this.blockSize;
        }
        Properties properties = System.getProperties();
        String string = properties.getProperty("org.jnetsoft.nio.BlockSize");
        string = string == null ? properties.getProperty("nio.BlockSize") : string;
        string = string == null ? properties.getProperty("org.jnetsoft.nio.blocksize") : string;
        string = string == null ? properties.getProperty("nio.blocksize") : string;
        String string2 = string = string == null ? properties.getProperty("nio.bs") : string;
        if (string != null) {
            this.blockSize = (int)JMemory.parseSize(string);
        }
        if (this.blockSize == 0) {
            this.blockSize = 32768;
        }
        return this.blockSize;
    }

    public void setBlockSize(int n) {
        this.blockSize = n;
    }

    public static class Block
    extends JMemory {
        private int available = 0;
        private int current = 0;
        private final long createdOn;

        Block(int n) {
            super(n);
            this.available = n;
            this.createdOn = System.currentTimeMillis();
        }

        Block(JMemory jMemory) {
            super(jMemory);
            this.createdOn = System.currentTimeMillis();
        }

        public synchronized int allocate(int n) {
            if ((n += n % BUS_WIDTH) > this.available) {
                return -1;
            }
            int n2 = this.current;
            this.available -= n;
            this.current += n;
            return n2;
        }

        public void free(int n, int n2) {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(80);
            stringBuilder.append("JMemoryPool::Block");
            stringBuilder.append('[');
            stringBuilder.append("capacity=").append(this.size());
            stringBuilder.append(',');
            stringBuilder.append("available=").append(this.current);
            stringBuilder.append(',');
            stringBuilder.append("createdOn=").append(new Time(this.createdOn).toString());
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

