package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.RegionTypeImpl.RegionType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.BiDirectionalMap;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.EnumMapping;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class RegionTypeImpl extends EnumMapping<RegionType> {

	public enum RegionType {
		NONE(0), CIRCLE(1), RECTANGLE(2), POLYGON(3), ID(4);
		
		private byte type;
		
		RegionType(int type) {
			this.type = (byte) (0x00FF & type);
		}
		
		public byte getType() {
			return this.type;
		}
		
		public int getNumber() {
			int i = type;
			i &= 0x00FF;
			return i;
		}
		
	}

	// singleton - to avoid multiple initialization
	private static RegionTypeImpl instance = null;

	private RegionTypeImpl() {
	}

	public static RegionTypeImpl getInstance() {
		if (instance == null)
			instance = new RegionTypeImpl();
		return instance;
	}

	@Override
	protected void initMapping(BiDirectionalMap<Integer, RegionType> map) {
		map.put(0, RegionType.NONE);
		map.put(1, RegionType.CIRCLE);
		map.put(2, RegionType.RECTANGLE);
		map.put(3, RegionType.POLYGON);
		map.put(4, RegionType.ID);
	}

}
