/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region;

import de.fraunhofer.sit.c2x.pki.ca.validator.Validator;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.RectangularRegion;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.shape.DoubleVector2d;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.Convert;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public abstract class AbstractRectangleValidator<T> implements Validator<T> {

	protected DoubleVector2d[] upperLeft;
	protected DoubleVector2d[] lowerRight;

	/**
	 * 
	 */
	public AbstractRectangleValidator(RectangularRegion[] rectangularRegion) {
		setRegions(rectangularRegion);
	}

	public AbstractRectangleValidator() {
	}

	public void setRegions(RectangularRegion[] rectangularRegions) {
		if (rectangularRegions == null || rectangularRegions.length == 0) {
			throw new IllegalArgumentException("<rectangularRegion> may not be null or empty");
		}
		upperLeft = new DoubleVector2d[rectangularRegions.length];
		lowerRight = new DoubleVector2d[rectangularRegions.length];

		for (int i = 0; i < rectangularRegions.length; i++) {
			upperLeft[i] = Convert.aTwoDLocation.toVector(rectangularRegions[i].getUpperLeft());
			lowerRight[i] = Convert.aTwoDLocation.toVector(rectangularRegions[i].getLowerRight());
		}
	}
}
