package de.fraunhofer.sit.c2x.pki.ca.validator.pseudonym.intervaltree;

import java.sql.Timestamp;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class Interval<DataType> implements Comparable<Interval<DataType>> {

	private long start, end;
	private DataType data;

	public Interval() {
	}

	public Interval(long start, long end, DataType data) {
		this.start = start;
		this.end = end;
		this.data = data;
	}

	public long getStart() {
		return start;
	}

	public Timestamp getStartTime() {
		return new Timestamp(start);
	}

	public void setStart(long start) {
		this.start = start;
	}

	public long getEnd() {
		return end;
	}

	public Timestamp getEndTime() {
		return new Timestamp(end);
	}

	public void setEnd(long end) {
		this.end = end;
	}

	public DataType getData() {
		return data;
	}

	public void setData(DataType data) {
		this.data = data;
	}

	/**
	 * @param time
	 * @return true if this interval contains time (invlusive)
	 */
	public boolean contains(long time) {
		return time < end && time > start;
	}

	/**
	 * @param other
	 * @return return true if this interval intersects other
	 */
	public boolean intersects(Interval<?> other) {
		return other.getEnd() > start && other.getStart() < end;
	}

	/**
	 * Return -1 if this interval's start time is less than the other, 1 if
	 * greater In the event of a tie, -1 if this interval's end time is less
	 * than the other, 1 if greater, 0 if same
	 * 
	 * @param other
	 * @return 1 or -1
	 */
	public int compareTo(Interval<DataType> other) {
		if (start < other.getStart())
			return -1;
		else if (start > other.getStart())
			return 1;
		else if (end < other.getEnd())
			return -1;
		else if (end > other.getEnd())
			return 1;
		else
			return 0;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((data == null) ? 0 : data.hashCode());
		result = prime * result + (int) (end ^ (end >>> 32));
		result = prime * result + (int) (start ^ (start >>> 32));
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Interval<?> other = (Interval<?>) obj;
		if (data == null) {
			if (other.data != null)
				return false;
		} else if (!data.equals(other.data))
			return false;
		if (end != other.end)
			return false;
		if (start != other.start)
			return false;
		return true;
	}

}
