package de.fraunhofer.sit.c2x.pki.ca.provider.interfaces;

import de.fraunhofer.sit.c2x.pki.ca.core.interfaces.Service;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets.UserRole;
import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.HttpUser;

public interface HttpUserProvider extends Service {

	UserRole getUserRole(String user, String password) throws ProviderException;

	HttpUser getUser(String username);

	int removeUser(String username) throws ProviderException;

	boolean save(HttpUser user) throws ProviderException;

	HttpUser[] getAll(int offset, int limit) throws ProviderException;

}
