package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.Certificate;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.CreationTime;

@Entity
@Table(name = Constants.ISSUED_CERTIFICATE_INFO__TABLE)
/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class IssuedCertificateInfo implements Serializable, CreationTime {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public IssuedCertificateInfo() {
	}

	@Id
	@Column(name = Constants.ISSUED_CERTIFICATE_INFO__COL__ID, columnDefinition = "varbinary(16)", nullable = false)
	private byte[] certId;

	@Column(name = Constants.ISSUED_CERTIFICATE_INFO__COL__CREATION_TIME)
	private Timestamp creationTime;

	@Column(name = Constants.ISSUED_CERTIFICATE_INFO__COL__START_TIME, nullable = false)
	private Timestamp startTime;

	@Column(name = Constants.ISSUED_CERTIFICATE_INFO__COL__EXPIRATION_TIME, nullable = false)
	private Timestamp expirationTime;

	@Column(name = Constants.ISSUED_CERTIFICATE_INFO__COL__CERTIFICATE, columnDefinition = "blob", nullable = false)
	private byte[] certificate;

	@Column(name = Constants.ISSUED_CERTIFICATE_INFO__COL__SUBJECT_NAME, nullable = false)
	private String subjectName;

	public Timestamp getStartTime() {
		return startTime;
	}

	public void setStartTime(Timestamp startTime) {
		this.startTime = startTime;
	}

	public Timestamp getExpirationTime() {
		return expirationTime;
	}

	public String getSubjectName() {
		return subjectName;
	}

	public void setSubjectName(String subjectName) {
		this.subjectName = subjectName;
	}

	public void setExpirationTime(Timestamp expirationTime) {
		this.expirationTime = expirationTime;
	}

	public byte[] getCertId() {
		return certId;
	}

	public void setCertId(byte[] certId) {
		this.certId = certId;
	}

	@Override
	public Timestamp getCreationTime() {
		return creationTime;
	}

	@Override
	public void setCreationTime(Timestamp creationTime) {
		this.creationTime = creationTime;
	}

	public byte[] getCertificate() {
		return certificate;
	}

	public void setCertificate(byte[] certificate) {
		this.certificate = certificate;
	}

	public void setCertificate(Certificate certificate) throws IOException {
		setCertificate(certificate.getCertificate());
		setCertId(certificate.getCertId());
		setStartTime(certificate.getStartTime());
		setExpirationTime(certificate.getExpirationTime());
		setCertId(certificate.getCertId());
		setSubjectName(certificate.getSubjectName());
	}

}