package de.fraunhofer.sit.c2x.pki.ca.certificates;

import java.io.IOException;
import java.util.ArrayList;

import org.apache.commons.codec.DecoderException;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;

import de.fraunhofer.sit.c2x.pki.ca.certificates.datacontainers.GeographicRegionDataContainer;
import de.fraunhofer.sit.c2x.pki.ca.certificates.datacontainers.PsidSspPriorityDataContainer;
import de.fraunhofer.sit.c2x.pki.ca.core.exceptions.HandlerException;
import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.Certificate;

public interface CertificateBuilder {

	Certificate createNewLongTermCaCertificate(String signingKeyX, String signingKeyY, String encryptionKeyX,
			String encryptionKeyY, String version, String algorithm, String symmetricAlgorithm,
			String compression, String startDate, String endDate,
			ArrayList<PsidSspPriorityDataContainer> psidSet, ECPrivateKeyParameters rootPrivateKey,
			byte[] rootCertificate, boolean addRootCertDigestAsSigner, String assuranceLevel,
			String subjectName, ArrayList<GeographicRegionDataContainer> regions) throws DecoderException,
			IOException, ProviderException, HandlerException;

	Certificate createNewLongTermCaCertificate(String signingKeyX, String signingKeyY, String encryptionKeyX,
			String encryptionKeyY, String version, String algorithm, String symmetricAlgorithm,
			String compression, String startDate, String endDate,
			ArrayList<PsidSspPriorityDataContainer> psidSet, ECPrivateKeyParameters rootPrivateKey,
			byte[] rootCertificate, boolean addRootCertDigestAsSigner, String assuranceLevel,
			String subjectName, ArrayList<GeographicRegionDataContainer> regions, boolean useHsm,
			char[] hsmLogin, String alias, String dllPath) throws DecoderException, IOException,
			ProviderException, HandlerException;

	String getCertificateAsHexString(Certificate cert) throws IOException;

	RootCertificateResult createNewRootCertificate(String startDate, String endDate, String assuranceLevel,
			String subjectName, ArrayList<GeographicRegionDataContainer> regions) throws IOException, HandlerException;

	RootCertificateResult createNewRootCertificate(String startDate, String endDate, String assuranceLevel,
			String subjectName, ArrayList<GeographicRegionDataContainer> regions, boolean useHsm, char[] hsmLogin, String alias, String dllPath)
			throws IOException, HandlerException;
	
	RootCertificateResult createNewRootCertificate(String startDate, String endDate, String assuranceLevel,
			String subjectName, ArrayList<PsidSspPriorityDataContainer> psidSet, ArrayList<GeographicRegionDataContainer> regions) throws IOException, HandlerException;

	RootCertificateResult createNewRootCertificate(String startDate, String endDate, String assuranceLevel,
			String subjectName, ArrayList<PsidSspPriorityDataContainer> psidSet, ArrayList<GeographicRegionDataContainer> regions, boolean useHsm, char[] hsmLogin, String alias, String dllPath)
			throws IOException, HandlerException;

	Certificate createNewPseudonymCaCertificate(String signingKeyX, String signingKeyY,
			String encryptionKeyX, String encryptionKeyY, String version, String algorithm,
			String symmetricAlgorithm, String compression, String startDate, String endDate,
			ArrayList<PsidSspPriorityDataContainer> psidSet, ECPrivateKeyParameters rootPrivateKey,
			byte[] rootCertificate, boolean addRootCertDigestAsSigner, String assuranceLevel,
			String subjectName, ArrayList<GeographicRegionDataContainer> regions) throws DecoderException,
			IOException, ProviderException, HandlerException;

	Certificate createNewPseudonymCaCertificate(String signingKeyX, String signingKeyY,
			String encryptionKeyX, String encryptionKeyY, String version, String algorithm,
			String symmetricAlgorithm, String compression, String startDate, String endDate,
			ArrayList<PsidSspPriorityDataContainer> psidSet, ECPrivateKeyParameters rootPrivateKey,
			byte[] rootCertificate, boolean addRootCertDigestAsSigner, String assuranceLevel,
			String subjectName, ArrayList<GeographicRegionDataContainer> regions, boolean useHsm,
			char[] hsmLogin, String alias, String dllPath) throws DecoderException, IOException,
			ProviderException, HandlerException;

	Certificate readCertificateFromBytes(byte[] certificate) throws IOException, ProviderException,
			HandlerException;

	Certificate createNewCrlSigner(String signingKeyX, String signingKeyY, String version, String algorithm,
			String compression, String startDate, String endDate, ECPrivateKeyParameters rootPrivateKey,
			byte[] rootCertificate, boolean addRootCertDigestAsSigner, String assuranceLevel,
			String subjectName) throws DecoderException, IOException, ProviderException, HandlerException;

	Certificate createNewCrlSigner(String signingKeyX, String signingKeyY, String version, String algorithm,
			String compression, String startDate, String endDate, ECPrivateKeyParameters rootPrivateKey,
			byte[] rootCertificate, boolean addRootCertDigestAsSigner, String assuranceLevel,
			String subjectName, boolean useHsm, char[] hsmLogin, String alias, String dllPath)
			throws DecoderException, IOException, ProviderException, HandlerException;

	Certificate createNewPseudonymCertificate(String signingKeyX, String signingKeyY,
			String encryptionKeyX, String encryptionKeyY, String version, String algorithm,
			String symmetricAlgorithm, String compression, String startDate, String endDate,
			ArrayList<PsidSspPriorityDataContainer> psidSet, ECPrivateKeyParameters issuerPrivateKey,
			byte[] issuerCertificate, String assuranceLevel,
			ArrayList<GeographicRegionDataContainer> regions) throws DecoderException, IOException,
			ProviderException, HandlerException;
}
