/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.lan;

import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;

@Header(nicname="llc")
public class IEEE802dot2
extends JHeader {
    public static final int ID = 7;

    @HeaderLength
    public static int headerLength(JBuffer jBuffer, int n) {
        return (jBuffer.getUShort(n + 2) & 3) == 3 ? 4 : 5;
    }

    @Field(offset=0, format="%x")
    public int control() {
        int n = this.getUByte(2);
        if ((n & 3) == 3) {
            return n;
        }
        return this.getUShort(2);
    }

    @Dynamic(value=Field.Property.LENGTH)
    public int controlLength() {
        return (super.getUByte(2) & 3) == 3 ? 8 : 16;
    }

    @Field(offset=0, length=8, format="%x")
    public int dsap() {
        return this.getUByte(0);
    }

    @Field(offset=8, length=8, format="%x")
    public int ssap() {
        return this.getUByte(1);
    }
}

