/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region.shape;

import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.PolygonPoint;


/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class Rectangle extends Polygon {

	/**
	 * @param path
	 */
	public Rectangle(DoubleVector2d upperLeft, DoubleVector2d lowerRight) {
		super(toPolygonPath(upperLeft, lowerRight));
	}

	private static PolygonPoint[] toPolygonPath(DoubleVector2d upperLeft, DoubleVector2d lowerRight) {
		DoubleVector2d upperRight = new DoubleVector2d(lowerRight.x, upperLeft.y);
		DoubleVector2d lowerLeft = new DoubleVector2d(upperLeft.x, lowerRight.y);
		return new PolygonPoint[] { new PolygonPoint(upperLeft), new PolygonPoint(upperRight),
				new PolygonPoint(lowerRight), new PolygonPoint(lowerLeft) };
	}

	public DoubleVector2d getUpperLeft() {
		return (DoubleVector2d) linkedPoints.get(0);
	}

	public DoubleVector2d getUpperRight() {
		return (DoubleVector2d) linkedPoints.get(1);
	}

	public DoubleVector2d getLowerRight() {
		return (DoubleVector2d) linkedPoints.get(2);
	}

	public DoubleVector2d getLowerLeft() {
		return (DoubleVector2d) linkedPoints.get(3);
	}

	public static Rectangle createRectangle(double... xy) {

		if (xy.length != 4)
			throw new IllegalArgumentException("invalid input");
		return new Rectangle(new DoubleVector2d(xy[0], xy[1]), new DoubleVector2d(xy[2], xy[3]));
	}

	public static Rectangle[] createRectangles(double... xy) {

		if (xy.length % 4 != 0)
			throw new IllegalArgumentException("invalid input");

		Rectangle[] regions = new Rectangle[(xy.length / 4)];
		int j = 0;
		for (int i = 0; i < regions.length; i = i + 4) {
			regions[j++] = new Rectangle(new DoubleVector2d(xy[i], xy[i + 1]), new DoubleVector2d(xy[i + 2],
					xy[i + 3]));
		}

		return regions;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.preserve.pki.ca.validator.shapes.Polygon#toString()
	 */
	@Override
	public String toString() {

		StringBuffer sb = new StringBuffer();
		sb.append(String.format("UL: (%g, %g) \n", getUpperLeft().x, getUpperLeft().y));
		sb.append(String.format("UR: (%g, %g) \n", getUpperRight().x, getUpperRight().y));
		sb.append(String.format("LR: (%g, %g) \n", getLowerRight().x, getLowerRight().y));
		sb.append(String.format("LL: (%g, %g) \n", getLowerLeft().x, getLowerLeft().y));
		sb.append("UL x------------------x UR \n");
		sb.append("   |                  | \n");
		sb.append("   |                  | \n");
		sb.append("   |                  | \n");
		sb.append("LL x------------------x LR \n");

		return sb.toString();
	}
}
