package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public interface Constants {

	public static final String ISSUED_CERTIFICATE_INFO__TABLE = "issued_certificates";
	public static final String ISSUED_CERTIFICATE_INFO__COL__ID = "certId";
	public static final String ISSUED_CERTIFICATE_INFO__COL__CERTIFICATE = "certificate";
	public static final String ISSUED_CERTIFICATE_INFO__COL__EXPIRATION_TIME = "expiration_time";
	public static final String ISSUED_CERTIFICATE_INFO__COL__START_TIME = "start_time";
	public static final String ISSUED_CERTIFICATE_INFO__COL__CREATION_TIME = "creation_time";
	public static final String ISSUED_CERTIFICATE_INFO__COL__SUBJECT_NAME = "subject_name";
	public static final String ISSUED_CERTIFICATE_INFO_LINK__TABLE = "issued_certificates_and_idk";

	public static final String CONFIGURATION__TABLE = "configurations";
	public static final String CONFIGURATION__COL__VALUE = "config_value";
	public static final String CONFIGURATION__COL__ID = "config_id";

	public static final String HTTP_USER__TABLE = "http_users";
	public static final String HTTP_USER__COL__ID = "http_user";
	public static final String HTTP_USER__COL__PASSWORD = "http_password";
	public static final String HTTP_USER__COL__ROLE = "http_role";
	public static final String HTTP_USER__COL__ITSS_REG_ID_PREFIX = "http_its_s_reg_id_prefix";

	public static final String KNOWN_CAS__TABLE = "known_cas";
	public static final String KNOWN_CAS__COL__CA_TYPE = "ca_type";
	public static final String KNOWN_CAS__COL__CERT_ID = "certId";
	public static final String KNOWN_CAS__COL__CERTIFICATE = "certificate";
	public static final String KNOWN_CAS__COL__X509_CLIENT_CERT = "x509_client_cert";
	public static final String KNOWN_CAS__COL__RSA_CLIENT_KEY = "rsa_client_key";
	public static final String KNOWN_CAS__COL__RSA_CLIENT_KEY_PASSWORD = "rsa_client_key_password";

	public static final String HOST__COL__ADDRESS = "host_adress";
	public static final String HOST__COL__PORT_HTTP = "host_port_http";
	public static final String HOST__COL__PORT_UDP = "host_port_udp";
	public static final String HOST__COL__WSDL_URL = "host_wsdl_url";
	
	public static final String AUTHORIZED_DEVICES__TABLE = "authorized_devices";
	public static final String AUTHORIZED_DEVICES__COL__PUBLIC_KEY = "public_key";
	public static final String AUTHORIZED_DEVICES__COL__ID = "canonical_id";
	public static final String AUTHORIZED_DEVICES__COL__CREATION_TIME = "creation_time";
	public static final String AUTHORIZED_DEVICES__COL__ITS_AID_LIST = "its_aid_list";
	public static final String AUTHORIZED_DEVICES__COL__ITS_AID_SSP_LIST = "its_aid_ssp_list";
	public static final String AUTHORIZED_DEVICES__COL__PRIORITY_ITS_AID_LIST = "priority_its_aid_list";
	public static final String AUTHORIZED_DEVICES__COL__PRIORITY_SSP_LIST = "priority_ssp_list";
	public static final String AUTHORIZED_DEVICES__COL__SUBJECT_ASSURANCE = "subject_assurance";
	public static final String AUTHORIZED_DEVICES__COL__CIRCULAR_REGION = "circular_region";
	public static final String AUTHORIZED_DEVICES__COL__IDENTIFIED_REGION = "id_region";
	public static final String AUTHORIZED_DEVICES__COL__DEACTIVATED = "deactivated";
	
	public static final String PUBLICKEY__COL__KEY = "publickey";
	public static final String PUBLICKEY__COL__ALGORITHM = "publickey_algorithm";
	public static final String CA_CERTIFICATE__COL__SIGNER_CERT_ID = "signer_certId";
	public static final String CA_CERTIFICATE__COL__SUBJECT_NAME = "subject_name";
	public static final String CA_CERTIFICATE__COL__EXPIRATION_TIME = "expiration_time";
	public static final String CA_CERTIFICATE__COL__START_TIME = "start_time";
	public static final String CA_CERTIFICATE__COL__CREATION_TIME = "creation_time";
	public static final String CA_CERTIFICATE__COL__CERTIFICATE = "certificate";
	public static final String CA_CERTIFICATE__COL__ID = "certId";
	public static final String CA_CERTIFICATE__COL__USAGE_ORDER = "usage_order";
	public static final String CA_CERTIFICATE__TABLE = "ca_certificate";
	
	public static final String CRL_CERTIFICATE__COL__SIGNER_CERT_ID = "signer_certId";
	public static final String CRL_CERTIFICATE__COL__SUBJECT_NAME = "subject_name";
	public static final String CRL_CERTIFICATE__COL__EXPIRATION_TIME = "expiration_time";
	public static final String CRL_CERTIFICATE__COL__START_TIME = "start_time";
	public static final String CRL_CERTIFICATE__COL__CREATION_TIME = "creation_time";
	public static final String CRL_CERTIFICATE__COL__CERTIFICATE = "certificate";
	public static final String CRL_CERTIFICATE__COL__ID = "certId";
	public static final String CRL_CERTIFICATE__TABLE = "crl_certificate";
	
	public static final String KEYSTORE__TABLE = "keystore";
	public static final String KEYSTORE__COL__KEYSTORE = "keystore";
	public static final String KEYSTORE__COL__CERT_ID = "certId";
	public static final String KEYSTORE__COL__ID = "id";

	public static final String CRL__TABLE = "crl";
	public static final String CRL__COL__CRL_BYTES = "crl";
	public static final String CRL__COL__NEXT_CRL = "next_crl";
	public static final String CRL__COL__START_PERIOD = "start_period";
	public static final String CRL__COL__CURRENT_SERIAL = "current_Serial";
	public static final String CRL__COL__CRL_SERIES = "crl_series";
	
	public static final String REVOKED__TABLE = "revoked_ca_certs";
	public static final String REVOKED__COL__ID = "revoked_cert";
	public static final String REVOKED__COL__TIME = "revocation_time";

	public static final String AUTHENTICATORS__TABLE = "authenticators";
	public static final String AUTHENTICATORS__COL__CREATION_TIME = "creation_time";
	public static final String AUTHENTICATORS__COL__COMPANY = "company";
	public static final String AUTHENTICATORS__COL__NAME = "name";
	public static final String AUTHENTICATORS__COL__EMAIL = "email";
	public static final String AUTHENTICATORS__COL__TELEPHONE = "telephone";
	public static final String AUTHENTICATORS__COL__ADDRESS = "address";
	public static final String AUTHENTICATORS__COL__CERTIFICATE = "certificate_x509_string";
	public static final String AUTHENTICATORS__COL__SUBJECT_ASSURANCE = "subject_assurance";
	public static final String AUTHENTICATORS__COL__ITS_AID_LIST = "its_aid_list";
	public static final String AUTHENTICATORS__COL__ITS_AID_SSP_LIST = "its_aid_ssp_list";
	public static final String AUTHENTICATORS__COL__PRIORITY_ITS_AID_LIST = "priority_its_aid_list";
	public static final String AUTHENTICATORS__COL__PRIORITY_SSP_LIST = "priority_ssp_list";
	public static final String AUTHENTICATORS__COL__CIRCULAR_REGION = "circular_region";
	public static final String AUTHENTICATORS__COL__IDENTIFIED_REGION = "id_region";
	
	public static final String MEASURING__TABLE = "measurings";
	public static final String MEASURING__COL__ID = "id";
	public static final String MEASURING__COL__TIME = "time";
	public static final String MEASURING__COL__STATION_TYPE = "station_type";
	public static final String MEASURING__COL__STATION_DIGEST = "station_digest";
	public static final String MEASURING__COL__REQUEST_HASH = "request_hash";
	public static final String MEASURING__COL__KEY = "m_key";
	public static final String MEASURING__COL__VALUE = "m_value";
	public static final String MEASURING__COL__NUMBER = "m_number";
	public static final String MEASURING__COL__NUMBER_PROCESSES = "number_processes";
	public static final String MEASURING__COL__MIN_TIME = "min_time";
	public static final String MEASURING__COL__MEAN_TIME = "mean_time";
	public static final String MEASURING__COL__MAX_TIME = "max_time";
	
	public static final String SLOT__ID__START_TIME = "startTime";
	public static final String SLOT__ID__END_TIME = "end_time";
	public static final String SLOT__ID__REGION = "region";
	public static final String SLOT__ID__CERT_ID = "certId";
	public static final String SLOT__COL__RESERVED = "reserved";
	public static final String SLOT__COL__ACTIVATED_CERTS = "activated_certs";
	public static final String SLOT__COL__CREATION_TIME = "creation_time";
	public static final String SLOT__TABLE = "pseudonym_interval";
	public static final String SLOT__COL__REQUEST_HASH = "request_hash";
}
