package de.fraunhofer.sit.c2x.pki.ca.module.webserver.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

import javax.servlet.http.HttpSession;

import org.eclipse.jetty.security.authentication.SessionAuthentication;

import com.google.inject.Inject;

import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.HtmlProvider;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.Servlet;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets.Category;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets.UserAuthentication;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.ConfigProvider;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class HtmlProviderImpl implements HtmlProvider {

	private List<Servlet> servlets;

	private ConfigProvider configProvider;

	// @InjectLogger
	// private Logger logger;

	@Inject
	public HtmlProviderImpl(ConfigProvider configProvider) {
		this.configProvider = configProvider;
	}

	@Override
	public String provide(HttpSession session, String pageTitle, String contentHtml) {

		StringBuilder sb = new StringBuilder();
		sb.append(HtmlUtils.headAsHtml(configProvider.get("webpageTitle")));
		sb.append(HtmlUtils.bodyAsHtml(
				configProvider.get("webpageTitle"),
				pageTitle,
				contentHtml,
				provideWebpageMenu(session, servlets),
				HtmlUtils.getWebpageFootHtml(configProvider.get("webpageProjectLogo"),
						configProvider.get("webpageFooterText"), configProvider.get("webpageProjectLogo"))));

		return sb.toString();
	}

	@Inject
	public void setServlets(List<Servlet> servlets) {
		this.servlets = servlets;
	}

	public String provideWebpageMenu(HttpSession session, List<Servlet> servlets) {
		SessionAuthentication user = (SessionAuthentication) session
				.getAttribute(SessionAuthentication.__J_AUTHENTICATED);

		// group servlets according to their category
		SortedMap<Category, List<Servlet>> groupedServelts = new TreeMap<Category, List<Servlet>>();
		for (Servlet s : servlets) {
			if (s.getCategory() != null) {
				if (groupedServelts.containsKey(s.getCategory()) == false)
					groupedServelts.put(s.getCategory(), new ArrayList<Servlet>());
				groupedServelts.get(s.getCategory()).add(s);
			}
		}

		StringBuilder sb = new StringBuilder();
		sb.append("<div id=\"left\">\n" + "<div id=\"navframe\">\n");
		for (Category c : groupedServelts.keySet()) {

			int rowCount = 0;
			for (Servlet servletContainer : groupedServelts.get(c)) {
				if (servletContainer.getCategory() != Category.NO_CATEGORY
						&& servletContainer.getCategory() != Category.NONE) {

					boolean userHasPermissionToAccess = false;
					if (servletContainer.getAllowedRoles().length > 0 && user != null) {
						// check whether user has on of the roles defined in the
						// servlet
						for (String role : servletContainer.getAllowedRoles()) {
							if (user.getUserIdentity().isUserInRole(role, null)) {
								userHasPermissionToAccess = true;
								break;
							}
						}
					}

					// show menu entry if servlet has no access restriction or
					// user has required role
					if ((servletContainer.getAllowedRoles().length == 0 && !servletContainer.isProtected())
							|| userHasPermissionToAccess) {

						if (rowCount++ == 0) {
							sb.append("<table cellspacing=\"0\" class=\"navInnerTable\">\n");
							sb.append("<tr>\n<th class=\"navcellhead\">" + c.toString() + "</th>\n</tr>\n");
						}
						sb.append("<tr>\n");
						sb.append("<td class=\"navcell\">"
								+ String.format("<a href=\"%s\">%s</a>", servletContainer.getUrl(),
										servletContainer.getTitle()) + "</td>\n");
						sb.append("</tr>\n");
					}

				}
			}
			if (c == Category.NONE) {
				sb.append("<table cellspacing=\"0\" class=\"navInnerTable\">\n");
				if (user != null)
					sb.append("<tr><td class=\"navcell\"><a href=\"" + UserAuthentication.URL
							+ "?logout=true\">Logout</a></td></tr>");
				else
					sb.append("<tr><td class=\"navcell\"><a href=\"" + UserAuthentication.URL
							+ "\">Login</a></td></tr>");
				sb.append("</table>\n");
			}
			if (rowCount > 0)
				sb.append("</table>\n");

		}
		sb.append("</div>\n</div>\n");

		return sb.toString();
	}

	@Override
	public String getFormatedUptime(long milliseconds) {
		return HtmlUtils.getFormatedUptime(milliseconds);
	}
}
