/**
 * @author      ETSI / STF462 / Alexandre Berge
 * @version     $URL$
 *              $Id$
 */
package org.etsi.ttcn.codec.its.uppertester;

import org.etsi.ttcn.tci.TciTypeClass;
import org.etsi.ttcn.codec.CodecFactory;
import org.etsi.ttcn.codec.generic.Record;

public class Plugin {

    public static void init() {
        // Basics
        CodecFactory cf = CodecFactory.getInstance();
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "", UtRecord.class);
        cf.setCodec(TciTypeClass.UNION, "UpperTester", "", UtUnion.class);
        cf.setCodec(TciTypeClass.BOOLEAN, "UpperTester", "", UtBoolean.class);
        // Gn
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtGnEventInd", UtEventInd.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "Payload", UtPayload.class);
        // Common
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtChangePosition", UtChangePosition.class);
        // DENM
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "SituationContainer", Record.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtDenmTrigger", UtDenmTrigger.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtDenmUpdate", UtDenmUpdate.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtDenmEventInd", UtEventInd.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtDenmTermination", UtDenmTermination.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtDenmTriggerResult", UtDenmTermination.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtDenmUpdateResult", UtDenmTermination.class);
        // CAM
        cf.setCodec(TciTypeClass.UNION, "UpperTester", "UtCamTrigger", UtCamTrigger.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtCamEventInd", UtEventInd.class);
        // MAPEM/SPATEM
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtMapemEventInd", UtEventInd.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtSpatemEventInd", UtEventInd.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtMapemSpatemTrigger", UtMapemSpatemTrigger.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtMapemSpatemTriggerResult", UtBoolean.class);
        // IVIM
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtIvimTrigger", UtIvimTrigger.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtIvimUpdate", UtIvimUpdate.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtIvimEventInd", UtEventInd.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtIvimTermination", UtIvimTermination.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtIvimTriggerResult", UtIvimTermination.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtIvimUpdateResult", UtIvimTermination.class);
        // SREM/SSEM
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtSremTrigger", UtSremTrigger.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtSremTriggerResult", UtBoolean.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtSremUpdate", UtSremUpdate.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtSremUpdateResult", UtBoolean.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtSremEventInd", UtEventInd.class);
        cf.setCodec(TciTypeClass.RECORD, "UpperTester", "UtSsemEventInd", UtEventInd.class);

    }
}